/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.xmlrpc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.ariane.tools.ToolBox;
import org.ariane.tools.TryProg;
import org.demo.webwader.Resources;
import org.demo.webwader.VersionInfo;
import org.demo.webwader.xmlrpc.XmlDisplayer;

public class PrintURL
extends TryProg {
    public static void main(String[] stringArray) {
        PrintURL printURL = new PrintURL();
        if (!printURL.parseArg(stringArray)) {
            System.err.println("Can't parse command line !");
            TryProg.exitWrong();
        }
        if (!printURL.run()) {
            System.err.println("Can't execute PrintURL !");
            TryProg.exitWrong();
        }
        System.exit(0);
    }

    public PrintURL() {
        super("PrintURL");
        this.setResources();
    }

    public boolean run() {
        if (ToolBox.debug) {
            System.out.println(VersionInfo.instance().toString());
        }
        try {
            this.startLoop();
            System.out.println("See you later !");
        }
        catch (Exception exception) {
            ToolBox.warn("Can't run PrintURL " + exception);
            return false;
        }
        return true;
    }

    private void startLoop() {
        this.printOptions();
        boolean bl = true;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        XmlDisplayer xmlDisplayer = XmlDisplayer.instance();
        while (bl) {
            System.out.print("Option : ");
            String string = null;
            try {
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                System.out.println("Can't read answer !");
            }
            if (string.equalsIgnoreCase("H") || string.equals("?")) {
                this.printOptions();
                continue;
            }
            if (string.equalsIgnoreCase("I") || string.equalsIgnoreCase("D")) {
                System.out.println("Displayer : " + xmlDisplayer.getName());
                continue;
            }
            if (string.equalsIgnoreCase("K")) {
                xmlDisplayer.kill();
                continue;
            }
            if (string.equalsIgnoreCase("Q") || string.equalsIgnoreCase("X")) {
                return;
            }
            try {
                xmlDisplayer.displayPage(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                ToolBox.warn("Invalid URL " + string, malformedURLException);
            }
        }
    }

    private void printOptions() {
        System.out.println();
        System.out.println("To get help    : 'h' or '?'");
        System.out.println("To get info    : 'i' or 'd'");
        System.out.println("To exit enter  : 'x' or 'q'");
        System.out.println("To kill server : 'k'");
        System.out.println("To display an URL give the location.");
        System.out.println();
        System.out.println();
    }

    protected void setResources() {
        this.resources = Resources.instance();
    }

    private void printUsage() {
        System.out.println("Usage   : java org.demo.webwader.xmlrpc.PrintURL [options]");
        System.out.println("Options : [-v|-d|-q][-V][-h]");
    }

    public boolean parseArg(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n++];
            int n3 = 1;
            while (n3 < string.length()) {
                char c = string.charAt(n3);
                switch (c) {
                    case 'V': {
                        VersionInfo.print();
                        return false;
                    }
                    case 'v': {
                        ToolBox.verbose = true;
                        ToolBox.debug = false;
                        break;
                    }
                    case 'd': {
                        ToolBox.verbose = true;
                        ToolBox.debug = true;
                        break;
                    }
                    case 'q': {
                        ToolBox.verbose = false;
                        ToolBox.debug = false;
                        break;
                    }
                    default: {
                        this.printUsage();
                        ++n2;
                    }
                }
                ++n3;
            }
        }
        return n2 == 0;
    }
}

