/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.xmlrpc;

import helma.xmlrpc.WebServer;
import helma.xmlrpc.XmlRpcException;
import helma.xmlrpc.XmlRpcHandler;
import java.io.IOException;
import java.util.Vector;
import org.ariane.tools.ToolBox;
import org.demo.webwader.BadConfigurationException;
import org.demo.webwader.Resources;
import org.demo.webwader.xmlrpc.XmlDisplayer;

class DisplayerServant
extends WebServer {
    private static final String NAME = "XmlDisplayerServant";
    public static final int PORT = 8380;

    protected DisplayerServant() throws IOException, BadConfigurationException {
        super(DisplayerServant.getPort());
        if (ToolBox.debug) {
            ToolBox.warn("XmlRpc port : " + this.getServerPort());
        }
        this.setParanoid(true);
        this.acceptClient("127.0.0.1");
        XmlDisplayer.setXmlDriver();
        this.addHandler("Displayer", this.getHandler());
    }

    public static final int getPort() {
        Resources resources = (Resources)Resources.instance();
        return resources.get("WebWader." + "XMLRPC.Port", 8380);
    }

    protected XmlRpcHandler getHandler() {
        return new DefaultDisplayHandler();
    }

    protected void warn(String string) {
        System.out.println(string + " !");
    }

    private class DefaultDisplayHandler
    implements XmlRpcHandler {
        private DefaultDisplayHandler() {
        }

        public Object execute(String string, Vector vector) throws Exception {
            if (string == null) {
                throw new XmlRpcException(0, "Invalid null method");
            }
            if (string.equals("kill")) {
                DisplayerServant.this.warn("XmlDisplayerServant killed");
                DisplayerServant.this.shutdown();
                return "killed";
            }
            if (string.equals("activate")) {
                DisplayerServant.this.warn("XmlDisplayerServant activated");
                return "activated";
            }
            if (string.equals("displayPage")) {
                if (vector == null) {
                    throw new XmlRpcException(0, "Missing url parameter");
                }
                Object e = vector.elementAt(0);
                DisplayerServant.this.warn(e.toString());
                return Boolean.TRUE;
            }
            if (string.equals("getName")) {
                return DisplayerServant.NAME;
            }
            throw new XmlRpcException(0, "Method not handled : " + string);
        }
    }
}

