/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.rbi;

import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.ariane.tools.ToolBox;
import org.demo.webwader.gui.Displayer;
import org.demo.webwader.gui.GuiResources;
import org.demo.webwader.rbi.NavePane;
import org.demo.webwader.rbi.SwingDisplayer;

public class SwingDisplayer
extends JEditorPane
implements Displayer {
    private static SwingDisplayer displayer = null;
    public static final String NAME = "RemoteSwing";
    private GuiResources resources = GuiResources.instance();

    protected static SwingDisplayer instance() {
        if (displayer == null) {
            displayer = new SwingDisplayer();
        }
        return displayer;
    }

    private SwingDisplayer() {
        this.setEditable(false);
        this.setOpaque(true);
        this.setBackground(this.resources.getPaneBackground());
        this.setForeground(this.resources.getPaneForeground());
        this.setFont(this.resources.getTextFont());
        class ClickListener
        implements HyperlinkListener {
            private final /* synthetic */ SwingDisplayer this$0;

            ClickListener(SwingDisplayer swingDisplayer) {
                this.this$0 = swingDisplayer;
            }

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                    HTMLDocument hTMLDocument = (HTMLDocument)this.this$0.getDocument();
                    hTMLDocument.processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)hyperlinkEvent);
                    return;
                }
                this.this$0.displayPage(hyperlinkEvent.getURL());
            }
        }
        this.addHyperlinkListener(new ClickListener(this));
    }

    public final void activate() {
        try {
            this.displayPage(new URL(GuiResources.getWelcomeLocation()));
        }
        catch (Exception exception) {
            ToolBox.warn("Can't display welcome page", exception);
            return;
        }
    }

    public final boolean displayPage(URL uRL) {
        if (uRL == null) {
            return false;
        }
        try {
            NavePane.instance().setURLField(uRL);
            this.setPage(uRL);
            return true;
        }
        catch (Exception exception) {
            ToolBox.warn("Can't display page " + uRL.toString(), exception);
            return false;
        }
    }

    public final String getName() {
        return NAME;
    }
}

