/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.rbi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.ariane.tools.ResourcesException;
import org.ariane.tools.ToolBox;
import org.ariane.tools.TryProg;
import org.demo.webwader.Resources;
import org.demo.webwader.VersionInfo;
import org.demo.webwader.rbi.DisplayersBag;
import org.demo.webwader.rbi.RemoteDisplayer;

public class ShowURL
extends TryProg {
    private String[] DISPLAYERS;

    public static void main(String[] stringArray) {
        ShowURL showURL = new ShowURL();
        if (!showURL.parseArg(stringArray)) {
            System.err.println("Can't parse command line !");
            TryProg.exitWrong();
        }
        if (!showURL.run()) {
            System.err.println("Can't execute ShowURL !");
            TryProg.exitWrong();
        }
        System.exit(0);
    }

    public ShowURL() {
        super("ShowURL");
        this.setResources();
    }

    public boolean run() {
        if (ToolBox.debug) {
            System.out.println(VersionInfo.instance().toString());
        }
        try {
            this.DISPLAYERS = DisplayersBag.instance().getNamesList();
            this.startLoop();
            System.out.println("See you later !");
        }
        catch (ResourcesException resourcesException) {
            ToolBox.warn("Can't manage resources " + resourcesException);
            return false;
        }
        catch (NotBoundException notBoundException) {
            ToolBox.warn("Can't find the servant " + notBoundException);
            return false;
        }
        catch (RemoteException remoteException) {
            ToolBox.warn("Can't create the connection " + remoteException);
            return false;
        }
        catch (Exception exception) {
            ToolBox.warn("Can't run ShowURL " + exception);
            return false;
        }
        return true;
    }

    private void startLoop() throws RemoteException, NotBoundException, MalformedURLException {
        int n = this.resources.get(".Registry.Port", 1099);
        Registry registry = LocateRegistry.getRegistry(n);
        RemoteDisplayer remoteDisplayer = (RemoteDisplayer)registry.lookup("//localhost/RemoteDisplayer");
        ToolBox.warn("Server contacted");
        this.printOptions();
        boolean bl = true;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while (bl) {
            System.out.print("Option : ");
            String string = null;
            try {
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                System.out.println("Can't read answer !");
            }
            if (string.equalsIgnoreCase("H") || string.equals("?")) {
                this.printOptions();
                continue;
            }
            if (string.equalsIgnoreCase("I") || string.equalsIgnoreCase("D")) {
                System.out.println("Displayer : " + remoteDisplayer.getName());
                continue;
            }
            if (string.equalsIgnoreCase("Q") || string.equalsIgnoreCase("X")) {
                return;
            }
            try {
                int n2 = Integer.parseInt(string);
                if (ToolBox.debug) {
                    System.out.println("Requested displayer : " + this.DISPLAYERS[n2]);
                }
                if (remoteDisplayer.changeDisplayer(this.DISPLAYERS[n2])) {
                    System.out.println("Displayer changed");
                    continue;
                }
                System.out.println("Displayer stays unchanged");
                continue;
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                ToolBox.warn("Invalid index", indexOutOfBoundsException);
                this.printOptions();
                continue;
            }
            catch (RemoteException remoteException) {
                ToolBox.warn("Can't change the displayer", remoteException);
                continue;
            }
            try {
                remoteDisplayer.displayPage(new URL(string));
            }
            catch (RemoteException remoteException) {
                ToolBox.warn("Can't display " + string, remoteException);
            }
            catch (MalformedURLException malformedURLException) {
                ToolBox.warn("Invalid URL " + string, malformedURLException);
            }
        }
    }

    private void printOptions() {
        System.out.println();
        System.out.println("To get help   : 'h' or '?'");
        System.out.println("To get info   : 'i' or 'd'");
        System.out.println("To exit enter : 'x' or 'q'");
        System.out.println("To display an URL give the location.");
        System.out.println("To change the displayer enter a number :");
        System.out.println();
        int n = 0;
        while (n < this.DISPLAYERS.length) {
            System.out.println(n + " : " + this.DISPLAYERS[n]);
            ++n;
        }
        System.out.println();
    }

    protected void setResources() {
        this.resources = Resources.instance();
    }

    private void printUsage() {
        System.out.println("Usage   : java org.demo.webwader.rbi.ShowURL [options]");
        System.out.println("Options : [-v|-d|-q][-V][-h]");
    }

    public boolean parseArg(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n++];
            int n3 = 1;
            while (n3 < string.length()) {
                char c = string.charAt(n3);
                switch (c) {
                    case 'V': {
                        VersionInfo.print();
                        return false;
                    }
                    case 'v': {
                        ToolBox.verbose = true;
                        ToolBox.debug = false;
                        break;
                    }
                    case 'd': {
                        ToolBox.verbose = true;
                        ToolBox.debug = true;
                        break;
                    }
                    case 'q': {
                        ToolBox.verbose = false;
                        ToolBox.debug = false;
                        break;
                    }
                    default: {
                        this.printUsage();
                        ++n2;
                    }
                }
                ++n3;
            }
        }
        return n2 == 0;
    }
}

