/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.rbi;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import org.ariane.tools.ToolBox;
import org.demo.webwader.rbi.BrowserPane;
import org.demo.webwader.rbi.Dialog;
import org.demo.webwader.rbi.DisplayersBag;
import org.demo.webwader.rbi.OptionPane;

class OptionPane
extends Dialog {
    private static OptionPane option_pane = null;
    private boolean verbose = true;
    private boolean debug = false;
    private JRadioButton quiet_button;
    private JRadioButton verbose_button;
    private JRadioButton debug_button;
    private JComboBox displayer_combo;
    private int displayer;

    protected static OptionPane instance() {
        if (option_pane == null) {
            option_pane = new OptionPane();
        }
        return option_pane;
    }

    private OptionPane() {
    }

    protected JComponent createComponent() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setBackground(this.resources.getPaneBackground());
        jTabbedPane.setForeground(this.resources.getPaneForeground());
        jTabbedPane.add("Displayer", this.createDisplayOptionsPane());
        jTabbedPane.add("Options", this.createMiscOptionsPane());
        Color color = this.resources.getPaneBackground().darker();
        jTabbedPane.setBackgroundAt(0, color);
        jTabbedPane.setBackgroundAt(1, color);
        this.setInitialSize("Options", 300, 200);
        return jTabbedPane;
    }

    private JComponent createMiscOptionsPane() {
        JPanel jPanel = new JPanel();
        Color color = this.resources.getPaneForeground();
        Component component = Box.createHorizontalStrut(this.resources.getSpace());
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setOpaque(true);
        jPanel.setBackground(this.resources.getPaneBackground());
        jPanel.setForeground(color);
        jPanel.setBorder(this.resources.getMarginBorder());
        JLabel jLabel = new JLabel("Verbosity : ");
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(this.resources.getLabelFont());
        jLabel.setHorizontalAlignment(2);
        jLabel.setForeground(color);
        jLabel.setToolTipText("To select one of quiet, verbose, debug");
        jPanel.add(jLabel);
        jPanel.add(component);
        ButtonGroup buttonGroup = new ButtonGroup();
        class VerbosityListener
        implements ActionListener {
            private final /* synthetic */ OptionPane this$0;

            VerbosityListener(OptionPane optionPane) {
                this.this$0 = optionPane;
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                char c = actionEvent.getActionCommand().charAt(0);
                switch (c) {
                    case 'Q': {
                        OptionPane.access$002(this.this$0, false);
                        OptionPane.access$102(this.this$0, false);
                        break;
                    }
                    case 'D': {
                        OptionPane.access$002(this.this$0, true);
                        OptionPane.access$102(this.this$0, true);
                        break;
                    }
                    default: {
                        OptionPane.access$002(this.this$0, true);
                        OptionPane.access$102(this.this$0, false);
                    }
                }
            }
        }
        VerbosityListener verbosityListener = new VerbosityListener(this);
        this.quiet_button = new JRadioButton("Quiet");
        if (!ToolBox.verbose && !ToolBox.debug) {
            this.quiet_button.setSelected(true);
        }
        this.quiet_button.addActionListener(verbosityListener);
        this.quiet_button.setFont(this.resources.getTextFont());
        this.quiet_button.setOpaque(false);
        this.quiet_button.setForeground(color);
        buttonGroup.add(this.quiet_button);
        jPanel.add(this.quiet_button);
        this.verbose_button = new JRadioButton("Verbose");
        if (ToolBox.verbose && !ToolBox.debug) {
            this.verbose_button.setSelected(true);
        }
        this.verbose_button.addActionListener(verbosityListener);
        this.verbose_button.setFont(this.resources.getTextFont());
        this.verbose_button.setOpaque(false);
        this.verbose_button.setForeground(color);
        buttonGroup.add(this.verbose_button);
        jPanel.add(this.verbose_button);
        this.debug_button = new JRadioButton("Debug");
        if (ToolBox.debug) {
            this.debug_button.setSelected(true);
        }
        this.debug_button.addActionListener(verbosityListener);
        this.debug_button.setFont(this.resources.getTextFont());
        this.debug_button.setOpaque(false);
        this.debug_button.setForeground(color);
        buttonGroup.add(this.debug_button);
        jPanel.add(this.debug_button);
        return jPanel;
    }

    private JComponent createDisplayOptionsPane() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        Color color = this.resources.getPaneForeground();
        jPanel.setLayout(gridBagLayout);
        jPanel.setOpaque(true);
        jPanel.setBackground(this.resources.getPaneBackground());
        jPanel.setForeground(color);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.right = gridBagConstraints.insets.left = this.resources.getSpace();
        gridBagConstraints.insets.top = 2 * gridBagConstraints.insets.left;
        gridBagConstraints.insets.bottom = gridBagConstraints.insets.left;
        JLabel jLabel = new JLabel("Displayer : ");
        jLabel.setFont(this.resources.getLabelFont());
        jLabel.setToolTipText("Tool used to display HTML pages");
        jLabel.setForeground(color);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.top = gridBagConstraints.insets.left;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.displayer_combo = new JComboBox<String>(DisplayersBag.instance().getNamesList());
        this.displayer_combo.setForeground(color);
        this.displayer_combo.setOpaque(false);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.displayer_combo, gridBagConstraints);
        jPanel.add(this.displayer_combo);
        class DisplayerListener
        implements ActionListener {
            private final /* synthetic */ OptionPane this$0;

            DisplayerListener(OptionPane optionPane) {
                this.this$0 = optionPane;
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                OptionPane.access$300(this.this$0, OptionPane.access$200(this.this$0).getSelectedIndex());
            }
        }
        this.displayer_combo.addActionListener(new DisplayerListener(this));
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (!this.confirmed) {
            return;
        }
        ToolBox.verbose = this.verbose;
        ToolBox.debug = this.debug;
        BrowserPane.instance().setDisplayer(this.displayer);
    }

    public boolean display() {
        if (!ToolBox.verbose && !ToolBox.debug) {
            this.verbose = false;
            this.debug = false;
            this.quiet_button.setSelected(true);
        } else if (ToolBox.debug) {
            this.verbose = true;
            this.debug = true;
            this.debug_button.setSelected(true);
        } else {
            this.verbose = true;
            this.debug = false;
            this.verbose_button.setSelected(true);
        }
        DisplayersBag displayersBag = DisplayersBag.instance();
        this.displayer_combo.setSelectedIndex(displayersBag.getDisplayerIndex());
        ((Component)this).setVisible(true);
        return this.confirmed;
    }

    private final void updateDisplayer(int n) {
        this.displayer = n;
    }

    static /* synthetic */ boolean access$002(OptionPane optionPane, boolean bl) {
        optionPane.verbose = bl;
        return optionPane.verbose;
    }

    static /* synthetic */ boolean access$102(OptionPane optionPane, boolean bl) {
        optionPane.debug = bl;
        return optionPane.debug;
    }

    static /* synthetic */ JComboBox access$200(OptionPane optionPane) {
        return optionPane.displayer_combo;
    }

    static /* synthetic */ void access$300(OptionPane optionPane, int n) {
        optionPane.updateDisplayer(n);
    }
}

