/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.rbi;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import org.ariane.tools.ToolBox;
import org.demo.webwader.gui.GuiResources;
import org.demo.webwader.rbi.BrowserPane;
import org.demo.webwader.rbi.ErrorWindow;
import org.demo.webwader.rbi.MainFrame;
import org.demo.webwader.rbi.NavePane;

class NavePane
extends JPanel {
    private static final String BACK_HOME = "Back Home";
    private static final String SHOW_URL = "Show URL";
    private GuiResources resources = GuiResources.instance();
    private JTextField url_field;
    private BrowserPane browser;
    private static NavePane nave_pane = null;

    protected static NavePane instance() {
        if (nave_pane == null) {
            nave_pane = new NavePane();
        }
        return nave_pane;
    }

    private NavePane() {
        ToolBox.dot();
        this.setLayout(new FlowLayout(0));
        this.setBackground(this.resources.getPaneBackground());
        this.setOpaque(true);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(this.resources.getMatteBorder(), this.resources.getLineBorder());
        this.setBorder(compoundBorder);
        JLabel jLabel = new JLabel("URL : ");
        jLabel.setForeground(this.resources.getPaneForeground());
        jLabel.setFont(this.resources.getLabelFont());
        this.add(jLabel);
        int n = jLabel.getHeight();
        ToolBox.dot();
        class UrlListener
        implements ActionListener {
            private final /* synthetic */ NavePane this$0;

            UrlListener(NavePane navePane) {
                this.this$0 = navePane;
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Back Home")) {
                    this.this$0.displayHomePage();
                } else if (string.equals("Show URL")) {
                    NavePane.access$000(this.this$0);
                }
            }
        }
        UrlListener urlListener = new UrlListener(this);
        int n2 = this.resources.get("Browser.URLField.Width", 80);
        this.url_field = new JTextField(n2);
        this.url_field.setFont(this.resources.getTextFont());
        this.url_field.setBackground(this.resources.getBoardBackground());
        this.url_field.setForeground(this.resources.getBoardForeground());
        this.url_field.setBorder(this.resources.getInBorder());
        this.url_field.setEditable(true);
        this.url_field.setText(null);
        this.url_field.addActionListener(urlListener);
        this.url_field.setActionCommand(SHOW_URL);
        this.add(this.url_field);
        ToolBox.dot();
        this.add(Box.createHorizontalGlue());
        JButton jButton = new JButton(this.resources.getIcon("home.gif"));
        Dimension dimension = new Dimension(31, 31);
        jButton.setToolTipText("Back to home page");
        jButton.addActionListener(urlListener);
        jButton.setActionCommand(BACK_HOME);
        jButton.setPreferredSize(dimension);
        this.add(jButton);
        int n3 = this.resources.get("Browser.Width", 800);
        this.setMaximumSize(new Dimension(n3, n += this.resources.getSpace()));
    }

    protected final void displayHomePage() {
        String string = this.resources.get("Browser.Home");
        if (string == null) {
            string = GuiResources.getWelcomeLocation();
        }
        this.displayURL(string);
    }

    protected final void displayURL(String string) {
        this.url_field.setText(string);
        this.displayPage();
    }

    private final void displayPage() {
        URL uRL = null;
        try {
            uRL = this.getURL();
            if (uRL == null) {
                return;
            }
            MainFrame.inform("Displaying : " + uRL);
            this.browser.displayPage(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            ErrorWindow.instance().display("Invalid URL specification");
        }
        catch (Exception exception) {
            ErrorWindow.instance().display("Can't display " + (uRL == null ? "null URL" : uRL.toString()));
        }
    }

    protected final void setURLField(URL uRL) {
        this.url_field.setText(uRL.toExternalForm());
    }

    protected final void setURLField(String string) {
        this.url_field.setText(string);
    }

    protected final URL getURL() throws MalformedURLException {
        String string = this.url_field.getText();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() < 1) {
            return null;
        }
        return new URL(string);
    }

    protected final void setBrowserPane(BrowserPane browserPane) {
        this.browser = browserPane;
    }

    static /* synthetic */ void access$000(NavePane navePane) {
        navePane.displayPage();
    }
}

