/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.rbi;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.ariane.applet.Messenger;
import org.ariane.gui.TimerBar;
import org.ariane.tools.ToolBox;
import org.demo.webwader.gui.GuiResources;
import org.demo.webwader.rbi.BrowserPane;
import org.demo.webwader.rbi.Confirmer;
import org.demo.webwader.rbi.HelpWindow;
import org.demo.webwader.rbi.NavePane;
import org.demo.webwader.rbi.OptionPane;
import org.demo.webwader.rbi.VersionWindow;

public class MainFrame
extends JFrame
implements ActionListener {
    private static final String SET_OPTIONS = "SetOptions";
    private static final String QUIT = "Quit";
    private static final String ABOUT = "About Browser ...";
    private static final String MANUAL = "Browser short help ...";
    private Container window;
    private static Messenger messenger;
    private TimerBar timerbar;
    private GuiResources resources;
    private static MainFrame main_frame;

    protected static MainFrame instance() {
        if (main_frame == null) {
            main_frame = new MainFrame("Browser Harness");
        }
        return main_frame;
    }

    protected static final void inform(String string) {
        messenger.display(string);
    }

    protected static final void clearMessage() {
        messenger.erase();
    }

    private MainFrame(String string) {
        super(string);
        ToolBox.dot();
        this.resources = GuiResources.instance();
        ToolBox.dot();
        int n = this.resources.get("Browser.Width", 800);
        int n2 = this.resources.get("Browser.Height", 700);
        ((Component)this).setSize(n, n2);
        JMenuBar jMenuBar = this.buildMenuBar();
        this.setJMenuBar(jMenuBar);
        this.window = this.getContentPane();
        this.window.setLayout(new BoxLayout(this.window, 1));
        this.window.setBackground(this.resources.getMainBackground());
        this.window.setForeground(this.resources.getMainForeground());
        this.window.setFont(this.resources.getHeaderFont());
        JComponent jComponent = this.buildTopPane();
        this.window.add(jComponent);
        jComponent.setAlignmentX(0.0f);
        ToolBox.dot();
        NavePane navePane = NavePane.instance();
        this.window.add(navePane);
        navePane.setAlignmentX(0.0f);
        ToolBox.dot();
        BrowserPane browserPane = BrowserPane.instance();
        browserPane.setAlignmentX(0.0f);
        this.window.add(browserPane);
        navePane.setBrowserPane(browserPane);
        ToolBox.dot();
        this.window.add(Box.createVerticalStrut(this.resources.getSpace()));
        JComponent jComponent2 = this.buildBottomPane();
        jComponent2.setAlignmentX(0.0f);
        this.window.add(jComponent2);
        ToolBox.dot();
        ((Component)this).setVisible(true);
        ToolBox.dot();
        System.out.println();
        MainFrame.inform("Welcome to this new session of Browser !");
    }

    private JComponent buildTopPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createRigidArea(new Dimension(this.resources.getSpace(), 50)));
        jPanel.setOpaque(false);
        Icon icon = this.resources.getIcon("jvs.gif");
        JLabel jLabel = new JLabel(icon);
        jLabel.setAlignmentX(0.0f);
        jLabel.setBorder(this.resources.getLineBorder());
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalGlue());
        icon = this.resources.getIcon(this.resources.get("Browser.Title", "browser.gif"));
        jLabel = new JLabel(icon);
        jLabel.setOpaque(false);
        jLabel.setAlignmentX(0.5f);
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(40 * this.resources.getSpace(), 0)));
        return jPanel;
    }

    private JComponent buildBottomPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.setOpaque(false);
        JComponent jComponent = this.buildMessageArea();
        int n = ((Component)jComponent).getHeight();
        jPanel.add(jComponent);
        jPanel.setMaximumSize(new Dimension(this.getWidth(), n));
        return jPanel;
    }

    private JComponent buildMessageArea() {
        JLabel jLabel = new JLabel();
        jLabel.setBackground(this.resources.getMainBackground());
        jLabel.setForeground(this.resources.getMainForeground());
        jLabel.setFont(this.resources.getTextFont());
        ToolBox.dot();
        messenger = new Messenger(jLabel);
        messenger.setDisplayTime(this.resources.get("DisplayTime", 5));
        return jLabel;
    }

    private JMenuBar buildMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        Color color = this.resources.getMainForeground();
        Color color2 = this.resources.getMainBackground();
        jMenuBar.setBackground(color2);
        jMenuBar.setForeground(color);
        JMenu jMenu = new JMenu("File");
        jMenu.setToolTipText("To execute main operations");
        jMenu.setOpaque(false);
        jMenu.setForeground(color);
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(QUIT);
        jMenuItem.setActionCommand(QUIT);
        this.setMenuItem(jMenuItem);
        jMenu.addSeparator();
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Settings");
        jMenu.setOpaque(false);
        jMenu.setForeground(color);
        jMenu.setToolTipText("To change current configuration");
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("Set options ...");
        jMenuItem.setActionCommand(SET_OPTIONS);
        this.setMenuItem(jMenuItem);
        jMenuItem.setToolTipText("To set various parameters");
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Help");
        jMenu.setOpaque(false);
        jMenu.setForeground(color);
        jMenuBar.add(jMenu);
        jMenu.setToolTipText("To get information about WebWader");
        jMenuItem = new JMenuItem(MANUAL);
        jMenuItem.setToolTipText("Where to find documentation");
        jMenu.add(jMenuItem);
        this.setMenuItem(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(ABOUT);
        jMenuItem.setToolTipText("To find out current version");
        jMenu.add(jMenuItem);
        this.setMenuItem(jMenuItem);
        return jMenuBar;
    }

    private final void setMenuItem(JMenuItem jMenuItem) {
        jMenuItem.addActionListener(this);
        jMenuItem.setBackground(this.resources.getMainBackground());
        jMenuItem.setForeground(this.resources.getMainForeground());
    }

    public String toString() {
        return "MainFrame " + this.getName();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(QUIT)) {
            this.processQuit();
        } else if (string.equals(SET_OPTIONS)) {
            this.processSetOptions();
        } else if (string.equals(MANUAL)) {
            this.processManual();
        } else if (string.equals(ABOUT)) {
            this.processAbout();
        } else {
            ToolBox.warn("Invalid command " + string);
        }
    }

    private final void processQuit() {
        if (Confirmer.instance().ask("Really want to quit ?")) {
            ToolBox.warn("See you later");
            System.exit(0);
        }
    }

    private final void processSetOptions() {
        OptionPane.instance().display();
    }

    private final void processManual() {
        HelpWindow.instance().display();
    }

    private final void processAbout() {
        VersionWindow.instance().display();
    }

    static {
        main_frame = null;
    }
}

