/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.rbi;

import ice.storm.ContentLoader;
import ice.storm.StormBase;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.JPanel;
import org.ariane.tools.ToolBox;
import org.demo.webwader.gui.Displayer;
import org.demo.webwader.gui.GuiResources;
import org.demo.webwader.rbi.IceDisplayer;
import org.demo.webwader.rbi.NavePane;

public class IceDisplayer
extends JPanel
implements Displayer {
    private static IceDisplayer displayer = null;
    public static final String NAME = "IceDisplayer";
    private GuiResources resources = GuiResources.instance();
    private StormBase base;

    public static IceDisplayer instance() {
        if (displayer == null) {
            displayer = new IceDisplayer();
        }
        return displayer;
    }

    private IceDisplayer() {
        this.setOpaque(true);
        this.setBackground(this.resources.getPaneBackground());
        this.setForeground(this.resources.getPaneForeground());
        this.setFont(this.resources.getTextFont());
        this.base = new StormBase();
        this.base.setComponentToolkitName("swing");
        this.base.setContainer((Container)this, NAME);
        class ClickListener
        implements PropertyChangeListener {
            private final /* synthetic */ IceDisplayer this$0;

            ClickListener(IceDisplayer iceDisplayer) {
                this.this$0 = iceDisplayer;
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("location")) {
                    NavePane.instance().setURLField((String)propertyChangeEvent.getNewValue());
                }
            }
        }
        this.base.addPropertyChangeListener((PropertyChangeListener)new ClickListener(this), null);
    }

    public final void activate() {
        try {
            this.displayPage(new URL(GuiResources.getWelcomeLocation()));
        }
        catch (Exception exception) {
            ToolBox.warn("Can't display welcome page", exception);
            return;
        }
    }

    public final boolean displayPage(URL uRL) {
        if (uRL == null) {
            return false;
        }
        try {
            NavePane.instance().setURLField(uRL);
            this.base.renderContent(new ContentLoader(uRL, null), NAME);
            return true;
        }
        catch (Exception exception) {
            ToolBox.warn("Can't display page " + uRL.toString(), exception);
            return false;
        }
    }

    public final String getName() {
        return NAME;
    }
}

