/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.rbi;

import horst.HTMLPane;
import horst.HTMLWindow;
import horst.LinkEvent;
import horst.LinkListener;
import java.net.URL;
import javax.swing.JComponent;
import org.ariane.tools.ToolBox;
import org.demo.webwader.gui.Displayer;
import org.demo.webwader.gui.GuiResources;
import org.demo.webwader.rbi.HorstDisplayer;
import org.demo.webwader.rbi.NavePane;

public class HorstDisplayer
extends HTMLWindow
implements Displayer {
    private static HorstDisplayer displayer = null;
    public static final String NAME = "HorstDisplayer";
    private GuiResources resources = GuiResources.instance();
    private HTMLPane pane;

    public static HorstDisplayer instance() {
        try {
            if (displayer == null) {
                displayer = new HorstDisplayer();
            }
        }
        catch (Throwable throwable) {
            if (ToolBox.debug) {
                System.err.println("Error in Horst HTMLWindow : " + throwable.getMessage());
            }
            displayer = new HorstDisplayer();
        }
        return displayer;
    }

    private HorstDisplayer() {
        ((JComponent)((Object)this)).setOpaque(true);
        ((JComponent)((Object)this)).setBackground(this.resources.getPaneBackground());
        ((JComponent)((Object)this)).setForeground(this.resources.getPaneForeground());
        ((JComponent)((Object)this)).setFont(this.resources.getTextFont());
        this.pane = new HTMLPane();
        this.setHTMLPane(this.pane);
        class ClickListener
        implements LinkListener {
            private final /* synthetic */ HorstDisplayer this$0;

            ClickListener(HorstDisplayer horstDisplayer) {
                this.this$0 = horstDisplayer;
            }

            public void mouseOverLink(LinkEvent linkEvent) {
            }

            public boolean mousePressedOverLink(LinkEvent linkEvent) {
                NavePane.instance().setURLField(linkEvent.getLink());
                return true;
            }
        }
        this.pane.addLinkListener((LinkListener)new ClickListener(this));
    }

    public final void activate() {
        try {
            this.displayPage(new URL(GuiResources.getWelcomeLocation()));
        }
        catch (Exception exception) {
            ToolBox.warn("Can't display welcome page", exception);
            return;
        }
    }

    public final boolean displayPage(URL uRL) {
        if (uRL == null) {
            return false;
        }
        try {
            NavePane.instance().setURLField(uRL);
            this.pane.openPage(uRL);
            return true;
        }
        catch (Exception exception) {
            ToolBox.warn("Can't display page " + uRL.toString(), exception);
            return false;
        }
    }

    public final String getName() {
        return NAME;
    }
}

