/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.rbi;

import java.awt.Dimension;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import org.ariane.tools.Resources;
import org.ariane.tools.ToolBox;
import org.demo.webwader.rbi.Dialog;

class HelpWindow
extends Dialog {
    private static HelpWindow window = null;

    protected static HelpWindow instance() {
        if (window == null) {
            window = new HelpWindow();
        }
        return window;
    }

    private HelpWindow() {
        super("Documentation  ", "help.gif");
        this.ok_button.setVisible(false);
        this.cancel_button.setToolTipText("To close the window");
    }

    protected JComponent createComponent() {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        jEditorPane.setOpaque(true);
        jEditorPane.setBackground(this.resources.getPaneBackground());
        jEditorPane.setForeground(this.resources.getPaneForeground());
        jEditorPane.setFont(this.resources.getTextFont());
        jEditorPane.setBorder(this.makeMarginBorder());
        this.setInitialSize("Help", 600, 700);
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        Dimension dimension = this.getInitialSize();
        int n = dimension.width;
        int n2 = dimension.height - 200;
        if (n2 < 100) {
            n2 = 100;
        }
        dimension.setSize(n, n2);
        jScrollPane.setPreferredSize(dimension);
        jScrollPane.setBorder(this.resources.getMatteBorder());
        URL uRL = null;
        try {
            uRL = this.getPage();
            jEditorPane.setPage(uRL);
        }
        catch (Exception exception) {
            jEditorPane.setText(this.writeText());
            ToolBox.warn("Can't get page " + String.valueOf(uRL), exception);
        }
        return jScrollPane;
    }

    private final String writeText() {
        StringBuffer stringBuffer = new StringBuffer("The documentation can be found at :");
        String string = this.resources.get("WebWader.DocURL", "http://jeanpaul.lefevre.free.fr/java/webwader/index.html");
        stringBuffer.append("\n").append(string).append("\n\n");
        stringBuffer.append("Use your favorite browser !");
        return stringBuffer.toString();
    }

    private final URL getPage() throws MalformedURLException {
        StringBuffer stringBuffer = new StringBuffer("file:");
        stringBuffer.append(Resources.instance().getLibDirectory());
        stringBuffer.append("browser-help.html");
        String string = stringBuffer.toString();
        return new URL(string);
    }
}

