/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.rbi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.ariane.tools.ToolBox;
import org.demo.webwader.gui.AbstractDisplayersBag;
import org.demo.webwader.gui.Displayer;
import org.demo.webwader.rbi.DisplayersProbe;
import org.demo.webwader.rbi.SwingDisplayer;

public class DisplayersBag
extends AbstractDisplayersBag {
    private static DisplayersBag bag = null;
    private static final int SWING = 0;
    private static final int CLUE = 1;
    private static final int HORST = 2;
    private static final int ICE = 3;
    protected Displayer[] instances = null;
    public static final String CLUE_DISPLAYER_NAME = "ClueDisplayer";
    public static final String ICE_DISPLAYER_NAME = "IceDisplayer";
    public static final String HORST_DISPLAYER_NAME = "HorstDisplayer";

    private DisplayersBag() {
        this.DISPLAYERS = new String[4];
        this.DISPLAYERS[0] = "RemoteSwing";
        this.DISPLAYERS[3] = ICE_DISPLAYER_NAME;
        this.DISPLAYERS[2] = HORST_DISPLAYER_NAME;
        this.DISPLAYERS[1] = CLUE_DISPLAYER_NAME;
        this.loadInstances();
    }

    public static DisplayersBag instance() {
        if (bag == null) {
            bag = new DisplayersBag();
        }
        return bag;
    }

    private void loadInstances() {
        this.instances = new Displayer[this.DISPLAYERS.length];
        int n = 0;
        try {
            this.instances[n] = SwingDisplayer.instance();
            n = 3;
            if (DisplayersProbe.isAvailable(this.DISPLAYERS[n])) {
                this.instances[n] = this.getInstance(ICE_DISPLAYER_NAME);
            }
            if (DisplayersProbe.isAvailable(this.DISPLAYERS[n = 1])) {
                this.instances[n] = this.getInstance(CLUE_DISPLAYER_NAME);
            }
            if (DisplayersProbe.isAvailable(this.DISPLAYERS[n = 2])) {
                this.instances[n] = this.getInstance(HORST_DISPLAYER_NAME);
            }
        }
        catch (Exception exception) {
            ToolBox.warn("Can't load instance of " + this.DISPLAYERS[n], exception);
        }
    }

    private final Displayer getInstance(String string) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName("org.demo.webwader.rbi." + string);
        Method method = clazz.getMethod("instance", null);
        return (Displayer)method.invoke(null, null);
    }

    public void printAvailable() {
        DisplayersProbe.isAvailable(ICE_DISPLAYER_NAME);
        int n = 0;
        while (n < this.DISPLAYERS.length) {
            String string = ToolBox.padString(this.DISPLAYERS[n] + " available", 30);
            System.out.println(string + ": " + String.valueOf(DisplayersProbe.isAvailable(this.DISPLAYERS[n])));
            ++n;
        }
    }

    protected final boolean setDisplayer(int n) {
        Displayer displayer = this.instances[n];
        if (displayer == null) {
            return false;
        }
        this.displayer = displayer;
        return true;
    }
}

