/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.rbi;

import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import org.ariane.tools.Resources;
import org.ariane.tools.ToolBox;
import org.demo.webwader.gui.Displayer;
import org.demo.webwader.gui.GuiResources;
import org.demo.webwader.rbi.DisplayersBag;
import org.demo.webwader.rbi.DisplayersProbe;
import org.demo.webwader.rbi.MainFrame;
import org.demo.webwader.rbi.NavePane;

class BrowserPane
extends JScrollPane {
    private static BrowserPane pane = null;
    private GuiResources resources = GuiResources.instance();
    private DisplayersBag bag = null;

    protected static BrowserPane instance() {
        if (pane == null) {
            pane = new BrowserPane();
        }
        return pane;
    }

    private BrowserPane() {
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(this.resources.getMatteBorder(), this.resources.getLineBorder());
        this.setBorder(compoundBorder);
        this.bag = DisplayersBag.instance();
        int n = this.bag.getDisplayerIndex(this.resources.get("Browser.Displayer", "SwingDisplayer"));
        this.bag.setDisplayer(n);
        Displayer displayer = this.bag.getDisplayer();
        this.setViewportView((Component)((Object)displayer));
        displayer.displayPage(this.getPage());
    }

    protected final boolean setDisplayer(int n) {
        int n2 = this.bag.getDisplayerIndex();
        if (n2 == n) {
            return false;
        }
        boolean bl = this.bag.setDisplayer(n);
        if (!bl) {
            MainFrame.inform("Displayer not changed !");
            return false;
        }
        Displayer displayer = this.bag.getDisplayer();
        if (displayer == null) {
            this.bag.setDisplayer(n2);
            return false;
        }
        MainFrame.inform("New displayer : " + displayer.getName());
        this.setViewportView((Component)((Object)displayer));
        URL uRL = null;
        try {
            uRL = NavePane.instance().getURL();
            if (uRL == null) {
                uRL = this.getPage();
            }
            displayer.displayPage(uRL);
        }
        catch (Exception exception) {
            ToolBox.warn("Can't get page " + String.valueOf(uRL), exception);
        }
        return true;
    }

    public final boolean changeDisplayer(String string) {
        if (!DisplayersProbe.isAvailable(string)) {
            if (ToolBox.verbose) {
                ToolBox.warn("Displayer " + string + " not available");
            }
            return false;
        }
        if (ToolBox.debug) {
            ToolBox.warn("Displayer : " + string);
        }
        return this.setDisplayer(this.bag.getDisplayerIndex(string));
    }

    protected final boolean displayPage(URL uRL) {
        return this.bag.getDisplayer().displayPage(uRL);
    }

    protected final String getDisplayerName() {
        return this.bag.getDisplayer().getName();
    }

    private final URL getPage() {
        StringBuffer stringBuffer = new StringBuffer("file:");
        stringBuffer.append(Resources.instance().getLibDirectory());
        stringBuffer.append("webpage.html");
        try {
            return new URL(stringBuffer.toString());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }
}

