/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.rbi;

import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Locale;
import org.ariane.tools.ResourcesException;
import org.ariane.tools.ToolBox;
import org.ariane.tools.TryProg;
import org.demo.webwader.Resources;
import org.demo.webwader.VersionInfo;
import org.demo.webwader.rbi.DisplayerServant;
import org.demo.webwader.rbi.DisplayersBag;
import org.demo.webwader.rbi.MainFrame;
import org.demo.webwader.rbi.NavePane;

public class Browser
extends TryProg {
    public static final String APPLI = "Browser";
    public static final String REGISTRY_PORT = ".Registry.Port";
    public static final String SERVANT = "//localhost/RemoteDisplayer";
    private String url = null;

    public static void main(String[] stringArray) {
        ToolBox.debug = false;
        ToolBox.verbose = true;
        Browser browser = new Browser();
        if (!browser.parseArg(stringArray)) {
            System.err.println("Can't parse command line !");
            TryProg.exitWrong();
        }
        if (!browser.run()) {
            System.err.println("Can't execute Browser !");
            TryProg.exitWrong();
        }
    }

    public Browser() {
        super(APPLI);
        this.setResources();
    }

    public boolean run() {
        Object object;
        if (ToolBox.verbose) {
            object = Locale.getDefault().getDisplayName();
            System.out.println("Creating Browser GUI " + (String)object + " !");
        }
        if (ToolBox.debug) {
            System.out.println(VersionInfo.instance().toString());
            DisplayersBag.instance().printAvailable();
        }
        ToolBox.dot();
        try {
            MainFrame.instance();
            object = NavePane.instance();
            if (this.url != null) {
                ((NavePane)object).displayURL(this.url);
            } else {
                ((NavePane)object).displayHomePage();
            }
            this.startServant();
        }
        catch (ResourcesException resourcesException) {
            ToolBox.warn("Can't manage resources " + resourcesException);
            ToolBox.warn("Try -Djvs.home=path_to_JVS or -cp path_to_JVS/lib/jvs.jar");
            return false;
        }
        catch (SecurityException securityException) {
            ToolBox.warn("Can't grant permission to run " + securityException);
            return false;
        }
        catch (RemoteException remoteException) {
            ToolBox.warn("Can't start the servant " + remoteException);
            return false;
        }
        catch (Exception exception) {
            ToolBox.warn("Can't run the Browser " + exception);
            if (ToolBox.debug) {
                exception.printStackTrace();
            }
            return false;
        }
        return true;
    }

    private void startServant() throws RemoteException, MalformedURLException {
        int n = this.resources.get(REGISTRY_PORT, 1099);
        Registry registry = LocateRegistry.createRegistry(n);
        n = this.resources.get("Browser.Port", 8334);
        DisplayerServant displayerServant = new DisplayerServant(n);
        String string = SERVANT;
        registry.rebind(string, displayerServant);
        StringBuffer stringBuffer = new StringBuffer("Displayer ");
        stringBuffer.append(string).append('(').append(displayerServant.getName()).append(')');
        stringBuffer.append(" bound on port ").append(n);
        ToolBox.warn(stringBuffer.toString());
    }

    protected void setResources() {
        this.resources = Resources.instance();
    }

    private void printUsage() {
        System.out.println("Usage   : java org.demo.webwader.bri.Browser [options]");
        System.out.println("Options : [-v|-d|-q][-V][-h] [url]");
    }

    public boolean parseArg(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n++];
            int n3 = 1;
            while (n3 < string.length()) {
                char c = string.charAt(n3);
                switch (c) {
                    case 'V': {
                        VersionInfo.print();
                        break;
                    }
                    case 'v': {
                        ToolBox.verbose = true;
                        ToolBox.debug = false;
                        break;
                    }
                    case 'd': {
                        ToolBox.verbose = true;
                        ToolBox.debug = true;
                        break;
                    }
                    case 'q': {
                        ToolBox.verbose = false;
                        ToolBox.debug = false;
                        break;
                    }
                    default: {
                        this.printUsage();
                        ++n2;
                    }
                }
                ++n3;
            }
        }
        if (n < stringArray.length) {
            this.url = stringArray[n++];
        }
        return n2 == 0;
    }
}

