/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.gui;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.ariane.exec.ExecutionException;
import org.ariane.tools.ToolBox;
import org.demo.webwader.gui.AbstractDisplayer;
import org.demo.webwader.gui.Displayer;
import org.demo.webwader.gui.ErrorWindow;

public class XmlDisplayer
extends AbstractDisplayer {
    private static XmlDisplayer instance = null;
    private Displayer displayer = null;
    public static final String NAME = "XBrowser";

    protected static XmlDisplayer instance() {
        if (instance == null) {
            instance = new XmlDisplayer();
        }
        return instance;
    }

    private XmlDisplayer() {
    }

    private final Displayer getInstance() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName("org.demo.webwader.xmlrpc.XmlDisplayer");
        Method method = clazz.getMethod("instance", null);
        return (Displayer)method.invoke(null, null);
    }

    public final String getRemoteName() {
        try {
            return this.displayer != null ? this.displayer.getName() : null;
        }
        catch (Exception exception) {
            if (ToolBox.debug) {
                ToolBox.warn("Can't get name of displayer", exception);
            }
            return null;
        }
    }

    public final void activate() {
        try {
            if (this.displayer == null) {
                this.displayer = this.getInstance();
            }
            this.displayer.activate();
        }
        catch (Throwable throwable) {
            ToolBox.warn("Can't activate xml displayer " + throwable.getMessage());
            ErrorWindow.instance().display("Can't activate " + this.getName() + " !\n" + "Check if this displayer is available.");
            this.displayer = null;
            throw new ExecutionException("Remote displayer activation failed");
        }
    }

    public final boolean displayPage(URL uRL) {
        try {
            if (!this.isToShow(uRL)) {
                return false;
            }
            this.displayer.displayPage(uRL);
        }
        catch (Exception exception) {
            ToolBox.warn("Can't display page with " + this.getName(), exception);
            ErrorWindow.instance().display("Can't display page with " + this.getName() + " !\n" + "Check if the connection is still alive.");
            return false;
        }
        return true;
    }

    public final String getName() {
        return NAME;
    }
}

