/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import org.ariane.tools.Resources;
import org.ariane.tools.ToolBox;
import org.demo.webwader.gui.Dialog;

class WebWindow
extends Dialog {
    private static WebWindow window = null;
    private JEditorPane editor;

    protected static WebWindow instance() {
        if (window == null) {
            window = new WebWindow();
        }
        return window;
    }

    private WebWindow() {
        super("Web Pager  ", "jvs.gif", false);
        this.ok_button.setVisible(false);
        this.cancel_button.setToolTipText("To close the window");
    }

    protected JComponent createComponent() {
        this.editor = new JEditorPane();
        this.editor.setEditable(false);
        this.editor.setOpaque(true);
        this.editor.setBackground(this.resources.getPaneBackground());
        this.editor.setForeground(this.resources.getPaneForeground());
        this.editor.setFont(this.resources.getTextFont());
        URL uRL = null;
        try {
            uRL = this.getPage();
            this.editor.setPage(uRL);
        }
        catch (Exception exception) {
            this.writeText(this.getText());
            ToolBox.warn("Can't get page " + String.valueOf(uRL), exception);
        }
        this.setInitialSize("WebWindow", 600, 700);
        JScrollPane jScrollPane = new JScrollPane(this.editor);
        Dimension dimension = this.getInitialSize();
        int n = dimension.width;
        int n2 = dimension.height - 200;
        if (n2 < 100) {
            n2 = 100;
        }
        dimension.setSize(n, n2);
        jScrollPane.setPreferredSize(dimension);
        jScrollPane.setBorder(this.resources.getMatteBorder());
        return jScrollPane;
    }

    protected final void display(InputStream inputStream, URL uRL) throws IOException {
        ((Component)this).setVisible(true);
        this.editor.read(inputStream, (Object)uRL);
    }

    protected final void writeText(String string) {
        this.editor.setText(string);
    }

    private String getText() {
        return "To see a Web Page use your favorite browser !";
    }

    private final URL getPage() throws MalformedURLException {
        StringBuffer stringBuffer = new StringBuffer("file:");
        stringBuffer.append(Resources.instance().getLibDirectory());
        stringBuffer.append("webpage.html");
        String string = stringBuffer.toString();
        return new URL(string);
    }
}

