/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.demo.webwader.InvalidLocatorException;
import org.demo.webwader.WebNode;
import org.demo.webwader.WebRoot;
import org.demo.webwader.WebSite;
import org.demo.webwader.gui.GuiResources;
import org.demo.webwader.gui.NavePane;
import org.demo.webwader.gui.TreePane;

public class TreePane
extends JTree {
    private static TreePane tree_pane = null;
    private DefaultMutableTreeNode root;

    protected static TreePane instance() {
        if (tree_pane == null) {
            tree_pane = new TreePane();
        }
        return tree_pane;
    }

    private TreePane() {
        GuiResources guiResources = GuiResources.instance();
        Color color = guiResources.getBoardForeground();
        this.setBackground(guiResources.getBoardBackground());
        this.setForeground(color);
        this.setEditable(false);
        this.setBorder(guiResources.getMarginBorder());
        this.getSelectionModel().setSelectionMode(1);
        class CellRenderer
        extends DefaultTreeCellRenderer {
            private final /* synthetic */ TreePane this$0;

            CellRenderer(TreePane treePane) {
                this.this$0 = treePane;
            }
        }
        CellRenderer cellRenderer = new CellRenderer(this);
        cellRenderer.setFont(guiResources.getTextFont());
        cellRenderer.setForeground(color);
        cellRenderer.setBackgroundNonSelectionColor(guiResources.getBoardBackground());
        cellRenderer.setBackgroundSelectionColor(guiResources.getSelectionColor());
        cellRenderer.setLeafIcon(guiResources.getIcon("text.gif"));
        cellRenderer.setOpenIcon(cellRenderer.getLeafIcon());
        cellRenderer.setClosedIcon(guiResources.getIcon("hypertext.gif"));
        this.setCellRenderer(cellRenderer);
        try {
            this.root = new WebRoot();
        }
        catch (InvalidLocatorException invalidLocatorException) {
            // empty catch block
        }
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.root);
        this.setModel(defaultTreeModel);
        class NodeListener
        implements TreeSelectionListener {
            private final /* synthetic */ TreePane this$0;

            NodeListener(TreePane treePane) {
                this.this$0 = treePane;
            }

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePane.access$000(this.this$0, (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent());
            }
        }
        this.addTreeSelectionListener(new NodeListener(this));
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public final void mouseClicked(MouseEvent mouseEvent) {
                TreePane.this.processNodeMouseSelection(mouseEvent);
            }
        };
        this.addMouseListener(mouseAdapter);
    }

    protected final void displaySiteMap(WebSite webSite) {
        this.root.removeAllChildren();
        if (webSite != null) {
            this.root.add(webSite.getTopNode());
        }
        ((DefaultTreeModel)this.getModel()).reload();
    }

    protected final void setDefaultCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private final void setBusyCursor() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    private final void processNodeSelection(DefaultMutableTreeNode defaultMutableTreeNode) {
        NavePane.instance().updateNodeInfo((WebNode)defaultMutableTreeNode);
    }

    private final void processNodeMouseSelection(MouseEvent mouseEvent) {
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        WebNode webNode = (WebNode)treePath.getLastPathComponent();
        NavePane.instance().displaySelectedNode(webNode);
    }

    protected void setSelectedNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = this.root;
        }
        TreeModel treeModel = this.getModel();
        Object[] objectArray = ((DefaultTreeModel)treeModel).getPathToRoot(defaultMutableTreeNode);
        TreePath treePath = new TreePath(objectArray);
        this.setSelectionPath(treePath);
    }

    static /* synthetic */ void access$000(TreePane treePane, DefaultMutableTreeNode defaultMutableTreeNode) {
        treePane.processNodeSelection(defaultMutableTreeNode);
    }
}

