/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.gui;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.ariane.tools.ResourcesException;
import org.ariane.tools.ToolBox;
import org.ariane.tools.TryProg;
import org.demo.webwader.Resources;
import org.demo.webwader.VersionInfo;
import org.demo.webwader.gui.Controller;
import org.demo.webwader.gui.DisplayersBag;
import org.demo.webwader.gui.MainFrame;
import org.demo.webwader.gui.ScanWindow;

public class Traverser
extends TryProg {
    public static final String APPLI = "WebWader";
    private MainFrame frame;
    private String sitefile = null;
    private boolean scanopen = false;

    public static void main(String[] stringArray) {
        ToolBox.debug = false;
        ToolBox.verbose = true;
        Traverser traverser = new Traverser();
        if (!traverser.parseArg(stringArray)) {
            System.err.println("Can't parse command line !");
            TryProg.exitWrong();
        }
        if (!traverser.run()) {
            System.err.println("Can't execute Traverser !");
            TryProg.exitWrong();
        }
    }

    public Traverser() {
        super("Traverser");
        this.setResources();
    }

    public boolean run() {
        Object object;
        if (ToolBox.verbose) {
            object = Locale.getDefault().getDisplayName();
            System.out.println("Creating Traverser GUI " + (String)object + " !");
        }
        if (ToolBox.debug) {
            System.out.println(VersionInfo.instance().toString());
            System.out.println("XML is available : " + ToolBox.hasXML());
        }
        ToolBox.dot();
        try {
            this.frame = MainFrame.instance();
            DisplayersBag.instance().setDisplayer(this.resources.get("WebWader.Displayer", "WebWindow"));
            if (this.scanopen) {
                ScanWindow.instance().display();
            }
        }
        catch (ResourcesException resourcesException) {
            ToolBox.warn("Can't manage resources " + resourcesException);
            ToolBox.warn("Try -Djvs.home=path_to_JVS or -cp path_to_JVS/lib/jvs.jar");
            return false;
        }
        catch (Exception exception) {
            ToolBox.warn("Can't run Traverser " + exception);
            return false;
        }
        if (this.sitefile != null) {
            try {
                object = new File(this.sitefile);
                Controller.instance().openFile((File)object);
            }
            catch (IOException iOException) {
                ToolBox.warn("Can't open " + this.sitefile, iOException);
            }
        }
        return true;
    }

    protected void setResources() {
        this.resources = Resources.instance();
    }

    private void printUsage() {
        System.out.println("Usage   : java org.demo.webwader.gui.Traverser [options]");
        System.out.println("Options : [-v|-d|-q][-V][-h][-S][-s sitefile]");
    }

    public boolean parseArg(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n++];
            int n3 = 1;
            while (n3 < string.length()) {
                char c = string.charAt(n3);
                switch (c) {
                    case 'V': {
                        VersionInfo.print();
                        break;
                    }
                    case 'v': {
                        ToolBox.verbose = true;
                        ToolBox.debug = false;
                        break;
                    }
                    case 'd': {
                        ToolBox.verbose = true;
                        ToolBox.debug = true;
                        break;
                    }
                    case 'q': {
                        ToolBox.verbose = false;
                        ToolBox.debug = false;
                        break;
                    }
                    case 'S': {
                        this.scanopen = true;
                        break;
                    }
                    case 's': {
                        this.sitefile = stringArray[n++];
                        break;
                    }
                    default: {
                        this.printUsage();
                        ++n2;
                    }
                }
                ++n3;
            }
        }
        return n2 == 0;
    }
}

