/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.gui;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.ariane.tools.ToolBox;
import org.demo.webwader.gui.AbstractDisplayer;
import org.demo.webwader.gui.GuiResources;
import org.demo.webwader.gui.WebWindow;

public class SwingDisplayer
extends AbstractDisplayer {
    private static SwingDisplayer displayer = null;
    private WebWindow window = WebWindow.instance();
    public static final String NAME = "LocalSwing";

    protected static SwingDisplayer instance() {
        if (displayer == null) {
            displayer = new SwingDisplayer();
        }
        return displayer;
    }

    private SwingDisplayer() {
    }

    public final void activate() {
        try {
            this.displayPage(new URL(GuiResources.getWelcomeLocation()));
        }
        catch (Exception exception) {
            ToolBox.warn("Can't display welcome page", exception);
            return;
        }
    }

    public final boolean displayPage(URL uRL) {
        if (uRL == null) {
            this.window.writeText("Nothing to display !");
            return false;
        }
        if (!this.isToShow(uRL)) {
            if (ToolBox.debug) {
                ToolBox.warn(uRL.toString() + " not shown");
            }
            return false;
        }
        try {
            String string = uRL.getProtocol();
            if (string.equals("file")) {
                this.window.display(uRL.openStream(), uRL);
                return true;
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            InputStream inputStream = httpURLConnection.getInputStream();
            this.window.display(inputStream, uRL);
        }
        catch (Exception exception) {
            this.window.writeText("Can't display " + uRL);
            if (ToolBox.debug) {
                ToolBox.warn("Can't display " + uRL, exception);
            }
            return false;
        }
        return true;
    }

    public final String getName() {
        return NAME;
    }
}

