/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.gui;

import java.io.BufferedOutputStream;
import java.net.Socket;
import java.net.URL;
import org.ariane.exec.ExecutionException;
import org.ariane.tools.ToolBox;
import org.demo.webwader.Resources;
import org.demo.webwader.gui.AbstractDisplayer;
import org.demo.webwader.gui.ErrorWindow;

class SocketDisplayer
extends AbstractDisplayer {
    private int port;
    private static SocketDisplayer displayer = null;
    protected static final String NAME = "Amaya";

    protected static SocketDisplayer instance() {
        if (displayer == null) {
            displayer = new SocketDisplayer();
        }
        return displayer;
    }

    protected SocketDisplayer() {
    }

    public final void activate() {
        String string = "";
        try {
            Resources resources = (Resources)Resources.instance();
            this.port = resources.get("WebWader.Socket.Port", 8333);
            URL uRL = new URL(Resources.getWelcomeLocation());
            if (!this.displayPage(uRL)) {
                throw new ExecutionException("Can't display welcome page");
            }
        }
        catch (Exception exception) {
            ToolBox.warn("Can't activate " + this.getName(), exception);
            ErrorWindow.instance().display("Can't activate Socket !\nCheck if it is running and try again.");
            throw new ExecutionException("Socket activation failed");
        }
    }

    public final boolean displayPage(URL uRL) {
        try {
            if (!this.isToShow(uRL)) {
                return false;
            }
            Socket socket = new Socket("localhost", this.port);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
            String string = uRL.toExternalForm();
            bufferedOutputStream.write(string.getBytes(), 0, string.length());
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            ToolBox.warn("Can't display page", exception);
            return false;
        }
        return true;
    }

    public final String getName() {
        return NAME;
    }
}

