/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.gui;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.ariane.gui.ConsoleWriter;
import org.demo.webwader.gui.Controller;
import org.demo.webwader.gui.Dialog;
import org.demo.webwader.gui.ScanPane;
import org.demo.webwader.gui.ScanWindow;

class ScanWindow
extends Dialog {
    private static ScanWindow window = null;
    private JTextArea text_pane;
    private ScanPane scan_pane;
    private PrintWriter printer;
    private int text_height = -1;

    protected static ScanWindow instance() {
        if (window == null) {
            window = new ScanWindow();
        }
        return window;
    }

    private ScanWindow() {
        super("Scan Dialog  ", "jvs.gif", false);
        this.ok_button.setToolTipText("To make this site current and close the window");
        this.cancel_button.setToolTipText("To stop the scan and close the window");
        class Listener
        implements ActionListener {
            private final /* synthetic */ ScanWindow this$0;

            Listener(ScanWindow scanWindow) {
                this.this$0 = scanWindow;
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                ScanWindow.access$000(this.this$0, actionEvent.getActionCommand());
            }
        }
        Listener listener = new Listener(this);
        this.ok_button.addActionListener(listener);
        this.cancel_button.addActionListener(listener);
        class Adapter
        extends WindowAdapter {
            private final /* synthetic */ ScanWindow this$0;

            Adapter(ScanWindow scanWindow) {
                this.this$0 = scanWindow;
            }

            public final void windowClosed(WindowEvent windowEvent) {
                ScanWindow.access$000(this.this$0, "Closed");
            }

            public final void windowClosing(WindowEvent windowEvent) {
                ScanWindow.access$000(this.this$0, "Closing");
            }
        }
        this.addWindowListener(new Adapter(this));
    }

    protected JComponent createComponent() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.setInitialSize("ScanWindow", 600, 600);
        JComponent jComponent = this.createBoard();
        jPanel.add(jComponent);
        JComponent jComponent2 = this.createConsole();
        jPanel.add(jComponent2);
        return jPanel;
    }

    private JComponent createBoard() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.resources.getPaneBackground());
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setOpaque(true);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(this.resources.getMatteBorder(), this.resources.getLineBorder());
        jPanel.setBorder(compoundBorder);
        this.scan_pane = ScanPane.instance();
        this.scan_pane.setAlignmentX(0.0f);
        jPanel.add(this.scan_pane);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    private JComponent createConsole() {
        this.text_pane = new JTextArea();
        this.text_pane.setEditable(false);
        this.text_pane.setOpaque(true);
        this.text_pane.setBackground(this.resources.getBoardBackground());
        this.text_pane.setForeground(this.resources.getBoardForeground());
        this.text_pane.setFont(this.resources.getTextFont());
        this.text_pane.setText(this.writeText());
        JScrollPane jScrollPane = new JScrollPane(this.text_pane);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(this.resources.getMatteBorder(), this.resources.getLineBorder());
        jScrollPane.setBorder(compoundBorder);
        class Listener
        implements ChangeListener {
            private final /* synthetic */ ScanWindow this$0;

            Listener(ScanWindow scanWindow) {
                this.this$0 = scanWindow;
            }

            public void stateChanged(ChangeEvent changeEvent) {
                ScanWindow.access$100(this.this$0, (JViewport)changeEvent.getSource());
            }
        }
        jScrollPane.getViewport().addChangeListener(new Listener(this));
        return jScrollPane;
    }

    private final void updateViewport(JViewport jViewport) {
        int n = this.text_pane.getHeight();
        if (this.text_height == n) {
            return;
        }
        this.text_height = n;
        int n2 = jViewport.getExtentSize().height;
        if (n <= n2) {
            return;
        }
        int n3 = n - n2;
        jViewport.setViewPosition(new Point(0, n3));
    }

    protected final PrintWriter getConsolePrinter() {
        if (this.printer == null) {
            ConsoleWriter consoleWriter = new ConsoleWriter(this.text_pane.getDocument());
            this.printer = new PrintWriter(consoleWriter);
        }
        return this.printer;
    }

    protected final void clearConsole() {
        this.text_pane.setText(null);
    }

    private final String writeText() {
        return "Waiting for a command !";
    }

    private final void processAction(String string) {
        if (string.equals("OK")) {
            Controller.instance().setNewWebSite(this.scan_pane.getWebSite());
        }
        this.scan_pane.killScan();
    }

    static /* synthetic */ void access$000(ScanWindow scanWindow, String string) {
        scanWindow.processAction(string);
    }

    static /* synthetic */ void access$100(ScanWindow scanWindow, JViewport jViewport) {
        scanWindow.updateViewport(jViewport);
    }
}

