/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.ariane.gui.TextField;
import org.ariane.tools.ToolBox;
import org.demo.webwader.Resources;
import org.demo.webwader.SiteScanner;
import org.demo.webwader.WebNode;
import org.demo.webwader.WebSite;
import org.demo.webwader.gui.ErrorWindow;
import org.demo.webwader.gui.GuiResources;
import org.demo.webwader.gui.ScanPane;
import org.demo.webwader.gui.ScanWindow;
import org.demo.webwader.gui.SiteRef;

public class ScanPane
extends JPanel
implements Runnable {
    private static ScanPane scan_pane = null;
    private JComboBox name_field;
    private int site_index;
    private TextField url_field;
    private JButton stop_button;
    private JButton start_button;
    private static final String STOP = "Stop";
    private static final String START = "Start";
    private int scan_order = 0;
    private WebSite site = null;
    private String ignored;

    protected static ScanPane instance() {
        if (scan_pane == null) {
            scan_pane = new ScanPane();
        }
        return scan_pane;
    }

    private ScanPane() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GuiResources guiResources = GuiResources.instance();
        Color color = guiResources.getPaneForeground();
        int n = guiResources.get("ScanPane.Width", 550);
        int n2 = guiResources.get("ScanPane.Height", 300);
        this.setMaximumSize(new Dimension(n, n2));
        this.setLayout(gridBagLayout);
        this.setBackground(guiResources.getPaneBackground());
        this.setForeground(color);
        this.setFont(guiResources.getHeaderFont());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.right = gridBagConstraints.insets.left = guiResources.getSpace();
        gridBagConstraints.insets.top = 2 * gridBagConstraints.insets.left;
        gridBagConstraints.insets.bottom = gridBagConstraints.insets.left;
        JLabel jLabel = new JLabel("Site Name : ");
        jLabel.setFont(guiResources.getLabelFont());
        jLabel.setForeground(color);
        org.ariane.gui.ToolBox.fixComponentSize(jLabel);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.right = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        int n3 = guiResources.get("NameField.Width", 48);
        this.name_field = new JComboBox();
        this.name_field.setFont(guiResources.getTextFont());
        this.name_field.setBackground(guiResources.getBoardBackground());
        this.name_field.setForeground(guiResources.getBoardForeground());
        this.name_field.setEditable(true);
        this.name_field.setBorder(guiResources.getInBorder());
        this.name_field.setToolTipText("Press Return to store the new name");
        class SelectionListener
        implements ItemListener {
            private final /* synthetic */ ScanPane this$0;

            SelectionListener(ScanPane scanPane) {
                this.this$0 = scanPane;
            }

            public final void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ScanPane.access$000(this.this$0);
                }
            }
        }
        this.name_field.addItemListener(new SelectionListener(this));
        class ReturnListener
        implements ActionListener {
            private final /* synthetic */ ScanPane this$0;

            ReturnListener(ScanPane scanPane) {
                this.this$0 = scanPane;
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                ScanPane.access$100(this.this$0);
            }
        }
        this.name_field.addActionListener(new ReturnListener(this));
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.name_field, gridBagConstraints);
        this.add(this.name_field);
        jLabel = new JLabel("Site URL : ");
        jLabel.setFont(guiResources.getLabelFont());
        jLabel.setForeground(color);
        org.ariane.gui.ToolBox.fixComponentSize(jLabel);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        n3 = guiResources.get("URLField.Width", 48);
        this.url_field = new TextField(n3);
        this.url_field.setFont(guiResources.getTextFont());
        this.url_field.setBackground(guiResources.getBoardBackground());
        this.url_field.setForeground(guiResources.getBoardForeground());
        this.url_field.setEditable(true);
        this.url_field.setText(null);
        class UrlListener
        implements ActionListener {
            private final /* synthetic */ ScanPane this$0;

            UrlListener(ScanPane scanPane) {
                this.this$0 = scanPane;
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                ScanPane.access$200(this.this$0);
            }
        }
        this.url_field.addActionListener(new UrlListener(this));
        this.url_field.setToolTipText("Press Return to store the new URL");
        gridBagConstraints.gridwidth = 3;
        gridBagLayout.setConstraints(this.url_field, gridBagConstraints);
        this.add(this.url_field);
        Dimension dimension = new Dimension(31, 31);
        Insets insets = new Insets(0, 0, 0, 0);
        class ScanListener
        implements ActionListener {
            private final /* synthetic */ ScanPane this$0;

            ScanListener(ScanPane scanPane) {
                this.this$0 = scanPane;
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                ScanPane.access$300(this.this$0, actionEvent.getActionCommand());
            }
        }
        ScanListener scanListener = new ScanListener(this);
        JButton jButton = new JButton(guiResources.getIcon("stop.gif"));
        jButton.setToolTipText("Stop the current scan");
        jButton.setMargin(insets);
        jButton.addActionListener(scanListener);
        jButton.setActionCommand(STOP);
        jButton.setPreferredSize(dimension);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        this.add(jButton);
        this.stop_button = jButton;
        jButton = new JButton(guiResources.getIcon("start.gif"));
        jButton.setToolTipText("Start a new scan");
        jButton.setMargin(insets);
        jButton.addActionListener(scanListener);
        jButton.setActionCommand(START);
        jButton.setPreferredSize(dimension);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets.right = 4 * gridBagConstraints.insets.bottom;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        this.add(jButton);
        this.start_button = jButton;
        this.setSitesList();
        this.setIgnoredList(Resources.instance().get("WebWader.Ignored"));
        this.updateButtonStatus(STOP);
    }

    private final void processAction(String string) {
        this.updateButtonStatus(string);
        if (string.equals(START)) {
            this.createSite();
            Thread thread = new Thread(this);
            thread.start();
        } else {
            this.killScan();
        }
    }

    public void run() {
        try {
            String string = this.url_field.getText();
            if (string == null || string.length() < 2) {
                ErrorWindow.instance().display("Invalid null URL !");
            } else {
                ScanWindow.instance().clearConsole();
                WebNode webNode = SiteScanner.instance().scan(this.site.getName(), string, this.scan_order);
                this.site.setTopNode(webNode);
            }
        }
        catch (Exception exception) {
            this.updateButtonStatus(STOP);
            if (ToolBox.debug) {
                ToolBox.warn("Can't scan site");
                exception.printStackTrace();
            }
            this.site = null;
            ErrorWindow.instance().display("Can't scan site :\n" + exception.getMessage());
            return;
        }
        this.backupWebSite();
        this.updateButtonStatus(STOP);
    }

    protected final void killScan() {
        if (this.site != null) {
            SiteScanner.instance().giveUpScan();
        }
        this.updateButtonStatus(STOP);
    }

    private final void backupWebSite() {
        if (this.site == null) {
            return;
        }
        try {
            this.site.write();
        }
        catch (Exception exception) {
            ToolBox.warn("Can't backup site", exception);
            if (ToolBox.debug) {
                exception.printStackTrace();
            }
            ErrorWindow.instance().display("Can't backup site !");
        }
    }

    private final void createSite() {
        this.site = new WebSite(this.getNameField());
        SiteScanner.instance().setPrinter(ScanWindow.instance().getConsolePrinter());
    }

    private final void updateButtonStatus(String string) {
        if (string.equals(START)) {
            this.start_button.setEnabled(false);
            this.stop_button.setEnabled(true);
        } else {
            this.start_button.setEnabled(true);
            this.stop_button.setEnabled(false);
        }
    }

    private final String getNameField() {
        return this.name_field.getSelectedItem().toString();
    }

    protected final WebSite getWebSite() {
        return this.site;
    }

    protected final int getScanningOrder() {
        return this.scan_order;
    }

    protected final void setScanningOrder(int n) {
        this.scan_order = n;
    }

    protected final String getIgnoredList() {
        return this.ignored;
    }

    protected final void setIgnoredList(String string) {
        this.ignored = string;
    }

    private final void setSitesList() {
        String string = GuiResources.instance().get("SitesList");
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                ToolBox.warn("Malformed list of sites for " + string2);
                return;
            }
            SiteRef siteRef = new SiteRef(string2, stringTokenizer.nextToken());
            this.name_field.addItem(siteRef);
        }
        if (this.name_field.getItemCount() > 0) {
            this.name_field.setSelectedIndex(0);
        }
    }

    protected final String getSitesList() {
        int n = this.name_field.getItemCount();
        if (n > 16) {
            n = 16;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            SiteRef siteRef = (SiteRef)this.name_field.getItemAt(n2);
            stringBuffer.append(siteRef.getReference()).append(' ');
            ++n2;
        }
        return stringBuffer.toString();
    }

    private final void selectSite() {
        Object object = this.name_field.getSelectedItem();
        if (!(object instanceof SiteRef)) {
            return;
        }
        this.site_index = this.name_field.getSelectedIndex();
        this.url_field.setText(((SiteRef)this.name_field.getItemAt(this.site_index)).getURL());
    }

    private final void updateSiteURL() {
        ((SiteRef)this.name_field.getItemAt(this.site_index)).setURL(this.url_field.getText());
    }

    private final void updateSitesList() {
        Object object = this.name_field.getSelectedItem();
        if (!(object instanceof String)) {
            return;
        }
        this.name_field.removeItem(object);
        String string = (String)object;
        string.trim();
        if (string.length() < 1) {
            if (this.name_field.getItemCount() > 0) {
                this.name_field.removeItemAt(this.site_index);
            }
            this.url_field.setText(null);
            return;
        }
        if (this.name_field.getItemCount() > 0 && string.equals(this.name_field.getItemAt(this.site_index).toString())) {
            return;
        }
        SiteRef siteRef = new SiteRef(string, this.url_field.getText());
        this.name_field.addItem(siteRef);
        this.name_field.setSelectedItem(siteRef);
    }

    static /* synthetic */ void access$000(ScanPane scanPane) {
        scanPane.selectSite();
    }

    static /* synthetic */ void access$100(ScanPane scanPane) {
        scanPane.updateSitesList();
    }

    static /* synthetic */ void access$200(ScanPane scanPane) {
        scanPane.updateSiteURL();
    }

    static /* synthetic */ void access$300(ScanPane scanPane, String string) {
        scanPane.processAction(string);
    }
}

