/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.gui;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import org.ariane.tools.ToolBox;
import org.demo.webwader.Resources;
import org.demo.webwader.gui.AbstractDisplayer;
import org.demo.webwader.gui.ErrorWindow;
import org.demo.webwader.gui.GuiResources;

class PrintURL
extends AbstractDisplayer {
    private static PrintURL displayer = null;
    private static String command = null;
    protected static final String NAME = "PrintURL";

    protected static PrintURL instance() {
        if (displayer == null) {
            displayer = new PrintURL();
        }
        return displayer;
    }

    private PrintURL() {
        File file;
        String string = Resources.instance().getBinDirectory();
        command = string + "print_url";
        if (ToolBox.isUnderWindows()) {
            command = command + ".exe";
        }
        if (!(file = new File(command)).exists()) {
            ToolBox.warn("Can't find " + command);
            command = null;
            return;
        }
        ToolBox.warn("Program " + command);
        command = command + " ";
    }

    public final void activate() {
        if (command == null) {
            ErrorWindow.instance().display("Can't activate PrintURL !");
            return;
        }
        try {
            this.displayPage(new URL(GuiResources.getWelcomeLocation()));
        }
        catch (Exception exception) {
            ToolBox.warn("Can't display welcome page", exception);
            return;
        }
    }

    public final String getName() {
        return NAME;
    }

    public final boolean displayPage(URL uRL) {
        if (uRL == null) {
            return false;
        }
        if (!this.isToShow(uRL)) {
            if (ToolBox.debug) {
                ToolBox.warn(uRL.toString() + " not shown");
            }
            return false;
        }
        try {
            Process process = Runtime.getRuntime().exec(command + uRL.toExternalForm());
            process.waitFor();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            System.out.println(bufferedReader.readLine());
        }
        catch (Exception exception) {
            ToolBox.warn("Can't display page " + uRL, exception);
            if (ToolBox.debug) {
                exception.printStackTrace();
            }
            return false;
        }
        return true;
    }
}

