/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.ariane.tools.ToolBox;
import org.demo.webwader.Resources;
import org.demo.webwader.WebNode;
import org.demo.webwader.gui.Dialog;
import org.demo.webwader.gui.DisplayersBag;
import org.demo.webwader.gui.ErrorWindow;
import org.demo.webwader.gui.MainFrame;
import org.demo.webwader.gui.NavePane;
import org.demo.webwader.gui.OptionPane;
import org.demo.webwader.gui.ScanPane;
import org.demo.webwader.gui.SwingDisplayer;

class OptionPane
extends Dialog {
    private static OptionPane option_pane = null;
    private NavePane nave_pane;
    private ScanPane scan_pane;
    private boolean verbose = true;
    private boolean debug = false;
    private JRadioButton quiet_button;
    private JRadioButton verbose_button;
    private JRadioButton debug_button;
    private JComboBox nave_combo;
    private int nave_order;
    private JComboBox displayer_combo;
    private int displayer = 0;
    private JTextField pause_field;
    private JTextField suffix_field;
    private JComboBox scan_combo;
    private int scan_order;
    private JTextField ignored_field;
    private boolean backup_done = false;

    protected static OptionPane instance() {
        if (option_pane == null) {
            option_pane = new OptionPane();
        }
        return option_pane;
    }

    private OptionPane() {
    }

    protected JComponent createComponent() {
        this.scan_pane = ScanPane.instance();
        this.nave_pane = NavePane.instance();
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setBackground(this.resources.getPaneBackground());
        jTabbedPane.setForeground(this.resources.getPaneForeground());
        jTabbedPane.add("Navigation", this.createNaveOptionsPane());
        jTabbedPane.add("Scanning", this.createScanOptionsPane());
        jTabbedPane.add("Options", this.createMiscOptionsPane());
        Color color = this.resources.getPaneBackground().darker();
        jTabbedPane.setBackgroundAt(0, color);
        jTabbedPane.setBackgroundAt(1, color);
        this.setInitialSize("Options", 300, 200);
        return jTabbedPane;
    }

    private JComponent createMiscOptionsPane() {
        JPanel jPanel = new JPanel();
        Color color = this.resources.getPaneForeground();
        Component component = Box.createHorizontalStrut(this.resources.getSpace());
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setOpaque(true);
        jPanel.setBackground(this.resources.getPaneBackground());
        jPanel.setForeground(color);
        jPanel.setBorder(this.resources.getMarginBorder());
        JLabel jLabel = new JLabel("Verbosity : ");
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(this.resources.getLabelFont());
        jLabel.setHorizontalAlignment(2);
        jLabel.setForeground(color);
        jLabel.setToolTipText("To select one of quiet, verbose, debug");
        jPanel.add(jLabel);
        jPanel.add(component);
        ButtonGroup buttonGroup = new ButtonGroup();
        class VerbosityListener
        implements ActionListener {
            private final /* synthetic */ OptionPane this$0;

            VerbosityListener(OptionPane optionPane) {
                this.this$0 = optionPane;
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                char c = actionEvent.getActionCommand().charAt(0);
                switch (c) {
                    case 'Q': {
                        OptionPane.access$002(this.this$0, false);
                        OptionPane.access$102(this.this$0, false);
                        break;
                    }
                    case 'D': {
                        OptionPane.access$002(this.this$0, true);
                        OptionPane.access$102(this.this$0, true);
                        break;
                    }
                    default: {
                        OptionPane.access$002(this.this$0, true);
                        OptionPane.access$102(this.this$0, false);
                    }
                }
            }
        }
        VerbosityListener verbosityListener = new VerbosityListener(this);
        this.quiet_button = new JRadioButton("Quiet");
        if (!ToolBox.verbose && !ToolBox.debug) {
            this.quiet_button.setSelected(true);
        }
        this.quiet_button.addActionListener(verbosityListener);
        this.quiet_button.setFont(this.resources.getTextFont());
        this.quiet_button.setOpaque(false);
        this.quiet_button.setForeground(color);
        buttonGroup.add(this.quiet_button);
        jPanel.add(this.quiet_button);
        this.verbose_button = new JRadioButton("Verbose");
        if (ToolBox.verbose && !ToolBox.debug) {
            this.verbose_button.setSelected(true);
        }
        this.verbose_button.addActionListener(verbosityListener);
        this.verbose_button.setFont(this.resources.getTextFont());
        this.verbose_button.setOpaque(false);
        this.verbose_button.setForeground(color);
        buttonGroup.add(this.verbose_button);
        jPanel.add(this.verbose_button);
        this.debug_button = new JRadioButton("Debug");
        if (ToolBox.debug) {
            this.debug_button.setSelected(true);
        }
        this.debug_button.addActionListener(verbosityListener);
        this.debug_button.setFont(this.resources.getTextFont());
        this.debug_button.setOpaque(false);
        this.debug_button.setForeground(color);
        buttonGroup.add(this.debug_button);
        jPanel.add(this.debug_button);
        return jPanel;
    }

    private JComponent createNaveOptionsPane() {
        JComponent jComponent = this.buildNaveOptionsPane();
        class NaveOrderListener
        implements ActionListener {
            private final /* synthetic */ OptionPane this$0;

            NaveOrderListener(OptionPane optionPane) {
                this.this$0 = optionPane;
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                OptionPane.access$300(this.this$0, OptionPane.access$200(this.this$0).getSelectedIndex());
            }
        }
        this.nave_combo.addActionListener(new NaveOrderListener(this));
        class DisplayerListener
        implements ActionListener {
            private final /* synthetic */ OptionPane this$0;

            DisplayerListener(OptionPane optionPane) {
                this.this$0 = optionPane;
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                OptionPane.access$500(this.this$0, OptionPane.access$400(this.this$0).getSelectedIndex());
            }
        }
        this.displayer_combo.addActionListener(new DisplayerListener(this));
        return jComponent;
    }

    private JComponent createScanOptionsPane() {
        JComponent jComponent = this.buildScanOptionsPane();
        class ScanOrderListener
        implements ActionListener {
            private final /* synthetic */ OptionPane this$0;

            ScanOrderListener(OptionPane optionPane) {
                this.this$0 = optionPane;
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                OptionPane.access$700(this.this$0, OptionPane.access$600(this.this$0).getSelectedIndex());
            }
        }
        this.scan_combo.addActionListener(new ScanOrderListener(this));
        return jComponent;
    }

    private JComponent buildNaveOptionsPane() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        Color color = this.resources.getPaneForeground();
        jPanel.setLayout(gridBagLayout);
        jPanel.setOpaque(true);
        jPanel.setBackground(this.resources.getPaneBackground());
        jPanel.setForeground(color);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.right = gridBagConstraints.insets.left = this.resources.getSpace();
        gridBagConstraints.insets.top = 2 * gridBagConstraints.insets.left;
        gridBagConstraints.insets.bottom = gridBagConstraints.insets.left;
        JLabel jLabel = new JLabel("Navigation");
        jLabel.setFont(this.resources.getLabelFont());
        jLabel.setHorizontalAlignment(0);
        jLabel.setToolTipText("To change navigation settings");
        jLabel.setForeground(color);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        JLabel jLabel2 = new JLabel("Displayer : ");
        jLabel2.setFont(this.resources.getLabelFont());
        jLabel2.setToolTipText("Tool used to display HTML pages");
        jLabel2.setForeground(color);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.top = gridBagConstraints.insets.left;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        this.displayer_combo = new JComboBox<String>(DisplayersBag.instance().getNamesList());
        this.displayer_combo.setForeground(color);
        this.displayer_combo.setOpaque(false);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.displayer_combo, gridBagConstraints);
        jPanel.add(this.displayer_combo);
        jLabel2 = new JLabel("Order : ");
        jLabel2.setFont(this.resources.getLabelFont());
        jLabel2.setToolTipText("Navigation order");
        jLabel2.setForeground(color);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.top = gridBagConstraints.insets.left;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        this.nave_combo = new JComboBox<String>(WebNode.ENUMERATION_MODE);
        this.nave_combo.setForeground(color);
        this.nave_combo.setOpaque(false);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.nave_combo, gridBagConstraints);
        jPanel.add(this.nave_combo);
        jLabel2 = new JLabel("Pause (s.) : ");
        jLabel2.setFont(this.resources.getLabelFont());
        jLabel2.setToolTipText("Display time in seconds");
        jLabel2.setForeground(color);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.top = gridBagConstraints.insets.left;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        int n = 8;
        this.pause_field = new JTextField(n);
        this.pause_field.setFont(this.resources.getTextFont());
        this.pause_field.setBackground(this.resources.getBoardBackground());
        this.pause_field.setForeground(this.resources.getBoardForeground());
        this.pause_field.setBorder(this.resources.getInBorder());
        this.pause_field.setEditable(true);
        this.pause_field.setHorizontalAlignment(4);
        this.pause_field.setText(String.valueOf(10));
        class PauseListener
        implements ActionListener {
            private final /* synthetic */ OptionPane this$0;

            PauseListener(OptionPane optionPane) {
                this.this$0 = optionPane;
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                try {
                    Integer.parseInt(OptionPane.access$800(this.this$0).getText());
                }
                catch (NumberFormatException numberFormatException) {
                    OptionPane.access$800(this.this$0).setText(String.valueOf(OptionPane.access$900(this.this$0).getPauseTime()));
                }
            }
        }
        this.pause_field.addActionListener(new PauseListener(this));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.pause_field, gridBagConstraints);
        jPanel.add(this.pause_field);
        jLabel2 = new JLabel("To display : ");
        jLabel2.setFont(this.resources.getLabelFont());
        jLabel2.setToolTipText("List of types to display");
        jLabel2.setForeground(color);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.top = gridBagConstraints.insets.left;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        n = 24;
        this.suffix_field = new JTextField(n);
        this.suffix_field.setFont(this.resources.getTextFont());
        this.suffix_field.setBackground(this.resources.getBoardBackground());
        this.suffix_field.setForeground(this.resources.getBoardForeground());
        this.suffix_field.setBorder(this.resources.getInBorder());
        this.suffix_field.setEditable(true);
        this.suffix_field.setText("htm html");
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.suffix_field, gridBagConstraints);
        jPanel.add(this.suffix_field);
        return jPanel;
    }

    private JComponent buildScanOptionsPane() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        Color color = this.resources.getPaneForeground();
        jPanel.setLayout(gridBagLayout);
        jPanel.setOpaque(true);
        jPanel.setBackground(this.resources.getPaneBackground());
        jPanel.setForeground(color);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.right = gridBagConstraints.insets.left = this.resources.getSpace();
        gridBagConstraints.insets.top = 2 * gridBagConstraints.insets.left;
        gridBagConstraints.insets.bottom = gridBagConstraints.insets.left;
        JLabel jLabel = new JLabel("Scanning");
        jLabel.setFont(this.resources.getLabelFont());
        jLabel.setHorizontalAlignment(0);
        jLabel.setToolTipText("To change scanning settings");
        jLabel.setForeground(color);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        JLabel jLabel2 = new JLabel("Order : ");
        jLabel2.setFont(this.resources.getLabelFont());
        jLabel2.setToolTipText("Scanning order");
        jLabel2.setForeground(color);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.top = gridBagConstraints.insets.left;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        this.scan_combo = new JComboBox<String>(WebNode.ENUMERATION_MODE);
        this.scan_combo.setForeground(color);
        this.scan_combo.setOpaque(false);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.scan_combo, gridBagConstraints);
        jPanel.add(this.scan_combo);
        jLabel2 = new JLabel("Ignored : ");
        jLabel2.setFont(this.resources.getLabelFont());
        jLabel2.setToolTipText("Ignore URL containing these tokens");
        jLabel2.setForeground(color);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.top = gridBagConstraints.insets.left;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        this.ignored_field = new JTextField(24);
        this.ignored_field.setFont(this.resources.getTextFont());
        this.ignored_field.setBackground(this.resources.getBoardBackground());
        this.ignored_field.setForeground(this.resources.getBoardForeground());
        this.ignored_field.setBorder(this.resources.getInBorder());
        this.ignored_field.setEditable(true);
        this.ignored_field.setHorizontalAlignment(2);
        this.ignored_field.setText(null);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.ignored_field, gridBagConstraints);
        jPanel.add(this.ignored_field);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (!this.confirmed) {
            return;
        }
        ToolBox.verbose = this.verbose;
        ToolBox.debug = this.debug;
        try {
            int n = Integer.parseInt(this.pause_field.getText());
            this.nave_pane.setPauseTime(n);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorWindow.instance().display("Invalid pause time value");
        }
        this.nave_pane.setNavigationOrder(this.nave_order);
        this.nave_pane.setDisplayer(this.displayer);
        SwingDisplayer.instance().setListOfSuffix(this.suffix_field.getText());
        this.scan_pane.setScanningOrder(this.scan_order);
        this.scan_pane.setIgnoredList(this.ignored_field.getText());
    }

    public boolean display() {
        if (!ToolBox.verbose && !ToolBox.debug) {
            this.verbose = false;
            this.debug = false;
            this.quiet_button.setSelected(true);
        } else if (ToolBox.debug) {
            this.verbose = true;
            this.debug = true;
            this.debug_button.setSelected(true);
        } else {
            this.verbose = true;
            this.debug = false;
            this.verbose_button.setSelected(true);
        }
        this.scan_combo.setSelectedIndex(this.scan_pane.getScanningOrder());
        this.ignored_field.setText(this.scan_pane.getIgnoredList());
        DisplayersBag displayersBag = DisplayersBag.instance();
        int n = displayersBag.getDisplayerIndex();
        if (n >= 0) {
            this.displayer_combo.setSelectedIndex(n);
        }
        this.nave_combo.setSelectedIndex(this.nave_pane.getNavigationOrder());
        this.pause_field.setText(String.valueOf(this.nave_pane.getPauseTime()));
        this.suffix_field.setText(SwingDisplayer.instance().getListOfSuffix());
        ((Component)this).setVisible(true);
        return this.confirmed;
    }

    private final void updateNavigationOrder(int n) {
        this.nave_order = n;
    }

    protected final void save() {
        if (ToolBox.debug) {
            ToolBox.warn("Saving current settings");
        }
        try {
            Properties properties = this.getUserProperties();
            Resources resources = (Resources)Resources.instance();
            String string = resources.getUserHomeDirectory() + ".jvs.properties";
            String string2 = this.backup_done ? string : ToolBox.markAsTemp(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            properties.store(fileOutputStream, " JVS Resources");
            fileOutputStream.close();
            if (!this.backup_done) {
                ToolBox.renameFile(string);
            }
            this.backup_done = true;
        }
        catch (Exception exception) {
            ErrorWindow.instance().display("Can't backup settings :\n" + exception.getMessage());
        }
    }

    private final Properties getUserProperties() throws IOException {
        Object object;
        Properties properties = new Properties();
        Resources resources = (Resources)Resources.instance();
        String string = resources.getUserHomeDirectory() + ".jvs.properties";
        File file = new File(string);
        if (file.exists()) {
            object = new FileInputStream(file);
            properties.load((InputStream)object);
            ((FileInputStream)object).close();
        }
        Object object2 = object = ToolBox.verbose ? "verbose" : "quiet";
        if (ToolBox.debug) {
            object = "debug";
        }
        ((Hashtable)properties).put("Mode", object);
        object = String.valueOf(this.nave_pane.getPauseTime());
        ((Hashtable)properties).put("WebWader.Navigation.Pause", object);
        object = this.nave_pane.getMode() ? "Manual" : "Automatic";
        ((Hashtable)properties).put("WebWader.Navigation.Mode", object);
        object = WebNode.navigationOrder(this.nave_pane.getNavigationOrder());
        ((Hashtable)properties).put("WebWader.Navigation.Order", object);
        ((Hashtable)properties).put("WebWader.Displayer", DisplayersBag.instance().getDisplayerName());
        object = SwingDisplayer.instance().getListOfSuffix();
        if (((String)object).length() > 0) {
            ((Hashtable)properties).put("WebWader.TypesToDisplay", object);
        }
        object = String.valueOf(this.nave_pane.getDoDisplay());
        ((Hashtable)properties).put("WebWader.DoDisplay", object);
        object = String.valueOf(MainFrame.instance().getShowMiniBoardState());
        ((Hashtable)properties).put("WebWader.ShowMiniBoard", object);
        object = WebNode.navigationOrder(this.scan_pane.getScanningOrder());
        ((Hashtable)properties).put("WebWader.Scanning.Order", object);
        object = this.scan_pane.getIgnoredList();
        if (((String)object).length() > 0) {
            ((Hashtable)properties).put("WebWader.Ignored", object);
        }
        if (((String)(object = this.scan_pane.getSitesList())).length() > 0) {
            ((Hashtable)properties).put("WebWader.SitesList", object);
        }
        return properties;
    }

    private final void updateDisplayer(int n) {
        this.displayer = n;
    }

    private final void updateScanningOrder(int n) {
        this.scan_order = n;
    }

    static /* synthetic */ boolean access$002(OptionPane optionPane, boolean bl) {
        optionPane.verbose = bl;
        return optionPane.verbose;
    }

    static /* synthetic */ boolean access$102(OptionPane optionPane, boolean bl) {
        optionPane.debug = bl;
        return optionPane.debug;
    }

    static /* synthetic */ JComboBox access$200(OptionPane optionPane) {
        return optionPane.nave_combo;
    }

    static /* synthetic */ void access$300(OptionPane optionPane, int n) {
        optionPane.updateNavigationOrder(n);
    }

    static /* synthetic */ JComboBox access$400(OptionPane optionPane) {
        return optionPane.displayer_combo;
    }

    static /* synthetic */ void access$500(OptionPane optionPane, int n) {
        optionPane.updateDisplayer(n);
    }

    static /* synthetic */ JComboBox access$600(OptionPane optionPane) {
        return optionPane.scan_combo;
    }

    static /* synthetic */ void access$700(OptionPane optionPane, int n) {
        optionPane.updateScanningOrder(n);
    }

    static /* synthetic */ JTextField access$800(OptionPane optionPane) {
        return optionPane.pause_field;
    }

    static /* synthetic */ NavePane access$900(OptionPane optionPane) {
        return optionPane.nave_pane;
    }
}

