/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.Timer;
import org.ariane.exec.ExecutionException;
import org.ariane.gui.TextField;
import org.ariane.tools.ToolBox;
import org.demo.webwader.WebNode;
import org.demo.webwader.WebSite;
import org.demo.webwader.gui.Controller;
import org.demo.webwader.gui.Displayer;
import org.demo.webwader.gui.DisplayersBag;
import org.demo.webwader.gui.ErrorWindow;
import org.demo.webwader.gui.GuiResources;
import org.demo.webwader.gui.MainFrame;
import org.demo.webwader.gui.NaveBoard;
import org.demo.webwader.gui.NavePane;
import org.demo.webwader.gui.TreePane;

class NavePane
extends JPanel
implements ActionListener {
    private static NavePane nave_pane = null;
    private TreePane tree_pane = null;
    private DisplayersBag bag = null;
    private boolean do_display = false;
    private TextField path_field;
    private TextField title_field;
    private JButton top_button;
    private JButton prev_button;
    private JButton stop_button;
    private JButton next_button;
    private JButton start_button;
    private JRadioButton auto_button;
    private JRadioButton manual_button;
    private ActionListener nave_listener;
    private ActionListener mode_listener;
    private Icon prev_icon;
    private Icon next_icon;
    private Icon start_icon;
    private Icon stop_icon;
    private boolean manual = true;
    private int nave_order = 0;
    private int pause_time = 1;
    private static final String TOP = "TOP";
    protected static final String PREV = "PREV";
    protected static final String STOP = "PREV";
    protected static final String NEXT = "NEXT";
    protected static final String START = "NEXT";
    private ListIterator iterator = null;
    private URL current_url = null;
    private boolean forward = true;
    private WebNode former = null;
    private Timer timer;
    private long ti;

    protected static NavePane instance() {
        if (nave_pane == null) {
            nave_pane = new NavePane();
        }
        return nave_pane;
    }

    private NavePane() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GuiResources guiResources = GuiResources.instance();
        Color color = guiResources.getPaneForeground();
        int n = guiResources.get("NavePane.Width", 450);
        int n2 = guiResources.get("NavePane.Height", 300);
        this.setMaximumSize(new Dimension(n, n2));
        this.setLayout(gridBagLayout);
        this.setBackground(guiResources.getPaneBackground());
        this.setForeground(color);
        this.setFont(guiResources.getHeaderFont());
        this.prev_icon = guiResources.getIcon("previous.gif");
        this.next_icon = guiResources.getIcon("next.gif");
        this.start_icon = guiResources.getIcon("start.gif");
        this.stop_icon = guiResources.getIcon("stop.gif");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.right = gridBagConstraints.insets.left = guiResources.getSpace();
        gridBagConstraints.insets.top = 2 * gridBagConstraints.insets.left;
        gridBagConstraints.insets.bottom = gridBagConstraints.insets.left;
        JLabel jLabel = new JLabel("Page path : ");
        jLabel.setFont(guiResources.getLabelFont());
        jLabel.setForeground(color);
        org.ariane.gui.ToolBox.fixComponentSize(jLabel);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.right = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        int n3 = guiResources.get("PathField.Width", 48);
        this.path_field = new TextField(n3);
        this.path_field.setFont(guiResources.getTextFont());
        this.path_field.setBackground(guiResources.getBoardBackground());
        this.path_field.setForeground(guiResources.getBoardForeground());
        this.path_field.setEditable(false);
        this.path_field.setText(null);
        gridBagConstraints.gridwidth = 4;
        gridBagLayout.setConstraints(this.path_field, gridBagConstraints);
        this.add(this.path_field);
        jLabel = new JLabel("Page title : ");
        jLabel.setFont(guiResources.getLabelFont());
        jLabel.setForeground(color);
        org.ariane.gui.ToolBox.fixComponentSize(jLabel);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.right = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        this.title_field = new TextField(n3);
        this.title_field.setFont(guiResources.getTextFont());
        this.title_field.setBackground(guiResources.getBoardBackground());
        this.title_field.setForeground(guiResources.getBoardForeground());
        this.title_field.setEditable(false);
        this.title_field.setText(null);
        gridBagConstraints.gridwidth = 4;
        gridBagLayout.setConstraints(this.title_field, gridBagConstraints);
        this.add(this.title_field);
        class NaveListener
        implements ActionListener {
            private final /* synthetic */ NavePane this$0;

            NaveListener(NavePane navePane) {
                this.this$0 = navePane;
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                NavePane.access$000(this.this$0, actionEvent.getActionCommand());
            }
        }
        this.nave_listener = new NaveListener(this);
        Dimension dimension = new Dimension(31, 31);
        Icon icon = guiResources.getIcon("home.gif");
        Insets insets = new Insets(0, 0, 0, 0);
        JButton jButton = new JButton(icon);
        jButton.setToolTipText("Return to Top");
        jButton.setMargin(insets);
        jButton.addActionListener(this.nave_listener);
        jButton.setActionCommand(TOP);
        jButton.setPreferredSize(dimension);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        this.add(jButton);
        this.top_button = jButton;
        jButton = new JButton(this.prev_icon);
        jButton.setToolTipText("Go to previous page");
        jButton.setMargin(insets);
        jButton.addActionListener(this.nave_listener);
        jButton.setActionCommand("PREV");
        jButton.setPreferredSize(dimension);
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        this.add(jButton);
        this.prev_button = jButton;
        this.stop_button = jButton;
        jButton = new JButton(this.next_icon);
        jButton.setToolTipText("Go to next page");
        jButton.setMargin(insets);
        jButton.addActionListener(this.nave_listener);
        jButton.setActionCommand("NEXT");
        jButton.setPreferredSize(dimension);
        gridBagConstraints.insets.right = 4 * gridBagConstraints.insets.bottom;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        this.add(jButton);
        this.next_button = jButton;
        this.start_button = jButton;
        ButtonGroup buttonGroup = new ButtonGroup();
        class ModeListener
        implements ActionListener {
            private final /* synthetic */ NavePane this$0;

            ModeListener(NavePane navePane) {
                this.this$0 = navePane;
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                NavePane.access$100(this.this$0, actionEvent.getActionCommand().charAt(0) == 'M');
                NaveBoard.instance().setMode(NavePane.access$200(this.this$0));
            }
        }
        this.mode_listener = new ModeListener(this);
        this.manual_button = new JRadioButton("Manual");
        this.manual_button.setToolTipText("Set manual mode");
        this.manual_button.setFont(guiResources.getTextFont());
        this.manual_button.setOpaque(false);
        this.manual_button.setForeground(color);
        this.manual_button.addActionListener(this.mode_listener);
        gridBagConstraints.insets.right = gridBagConstraints.insets.bottom;
        gridBagConstraints.insets.left = 4 * gridBagConstraints.insets.bottom;
        gridBagLayout.setConstraints(this.manual_button, gridBagConstraints);
        this.add(this.manual_button);
        buttonGroup.add(this.manual_button);
        this.auto_button = new JRadioButton("Auto");
        this.auto_button.setToolTipText("Set automatic mode");
        this.auto_button.setFont(guiResources.getTextFont());
        this.auto_button.setOpaque(false);
        this.auto_button.setForeground(color);
        this.auto_button.addActionListener(this.mode_listener);
        gridBagConstraints.insets.left = gridBagConstraints.insets.bottom;
        gridBagLayout.setConstraints(this.auto_button, gridBagConstraints);
        this.add(this.auto_button);
        buttonGroup.add(this.auto_button);
        String string = guiResources.get("Navigation.Mode", "Manual");
        this.setMode(string.equalsIgnoreCase("Manual"));
        this.timer = new Timer(this.getSleepTime(), this);
        this.timer.setRepeats(false);
        this.setPauseTime(guiResources.get("Navigation.Pause", 10));
        string = guiResources.get("Navigation.Order", "BreadthFirst");
        this.setNavigationOrder(WebNode.navigationOrder(string));
        this.bag = DisplayersBag.instance();
    }

    protected final boolean getMode() {
        return this.manual;
    }

    private final void setMode(boolean bl) {
        this.manual = bl;
        if (bl) {
            this.manual_button.setSelected(true);
            this.prev_button.setIcon(this.prev_icon);
            this.prev_button.setToolTipText("Go to previous page");
            this.next_button.setIcon(this.next_icon);
            this.next_button.setToolTipText("Go to next page");
            this.top_button.setEnabled(true);
            this.prev_button.setEnabled(true);
            this.next_button.setEnabled(true);
        } else {
            this.auto_button.setSelected(true);
            this.stop_button.setIcon(this.stop_icon);
            this.stop_button.setToolTipText("Stop navigation in progress");
            this.start_button.setIcon(this.start_icon);
            this.start_button.setToolTipText("Start new navigation");
            this.top_button.setEnabled(true);
            this.start_button.setEnabled(true);
            this.stop_button.setEnabled(false);
        }
    }

    protected final void updateNodeInfo(WebNode webNode) {
        if (webNode == null) {
            this.path_field.setText(null);
            this.title_field.setText(null);
            return;
        }
        this.path_field.setText(webNode.getPagePath());
        this.title_field.setText(webNode.getTitle());
    }

    protected final ActionListener getNaveListener() {
        return this.nave_listener;
    }

    protected final ActionListener getModeListener() {
        return this.mode_listener;
    }

    private final void processAction(String string) {
        if (this.tree_pane == null) {
            this.tree_pane = TreePane.instance();
        }
        if (this.manual) {
            this.processManualAction(string);
        } else {
            this.processAutoAction(string);
        }
    }

    private final void processManualAction(String string) {
        if (string.equals(TOP)) {
            this.former = null;
            this.forward = true;
            this.resetIterator();
            this.tree_pane.setSelectedNode(null);
            return;
        }
        this.getIterator();
        if (this.iterator == null) {
            return;
        }
        WebNode webNode = this.former;
        try {
            if (string.equals("NEXT")) {
                if (!this.forward) {
                    if (this.former != null) {
                        webNode = (WebNode)this.iterator.next();
                    }
                    this.forward = true;
                }
                if (!this.iterator.hasNext()) {
                    this.resetIterator();
                    this.getIterator();
                }
                webNode = (WebNode)this.iterator.next();
            } else if (string.equals("PREV")) {
                if (this.forward) {
                    if (this.former != null) {
                        webNode = (WebNode)this.iterator.previous();
                    }
                    this.forward = false;
                }
                if (!this.iterator.hasPrevious()) {
                    this.positionIterator(null);
                }
                webNode = (WebNode)this.iterator.previous();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            ToolBox.warn("Invalid manual action " + string, noSuchElementException);
        }
        this.former = webNode;
        this.tree_pane.setSelectedNode(webNode);
        this.displayPage(webNode);
    }

    private final void processAutoAction(String string) {
        this.updateButtonStatus(string);
        this.forward = true;
        if (string.equals("NEXT")) {
            this.ti = System.currentTimeMillis();
            this.actionPerformed(null);
        } else if (string.equals(TOP)) {
            this.former = null;
            this.resetIterator();
            this.tree_pane.setSelectedNode(null);
            MainFrame.instance().stopTimer();
        } else {
            this.timer.stop();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.getIterator();
        if (this.iterator == null) {
            this.updateButtonStatus("PREV");
            this.timer.stop();
            return;
        }
        if (!this.iterator.hasNext()) {
            this.actionStopped();
            return;
        }
        WebNode webNode = (WebNode)this.iterator.next();
        this.tree_pane.setSelectedNode(webNode);
        boolean bl = this.displayPage(webNode);
        if (bl) {
            this.timer.start();
            MainFrame.instance().startTimer(this.getSleepTime());
        } else {
            this.timer.setInitialDelay(10);
            this.timer.start();
            this.timer.setInitialDelay(this.getSleepTime());
        }
        this.former = webNode;
    }

    private void actionStopped() {
        this.timer.stop();
        this.resetIterator();
        this.updateButtonStatus("PREV");
        long l = (System.currentTimeMillis() - this.ti) / 1000L;
        MainFrame.inform("Navigation done in " + l + " s.");
    }

    protected final void displaySelectedNode(WebNode webNode) {
        if (webNode == null) {
            ToolBox.warn("Can't display null selected node");
            return;
        }
        this.positionIterator(webNode);
        this.displayPage(webNode);
    }

    private final void updateButtonStatus(String string) {
        if (string.equals("NEXT")) {
            this.top_button.setEnabled(false);
            this.start_button.setEnabled(false);
            this.stop_button.setEnabled(true);
            this.manual_button.setEnabled(false);
            this.auto_button.setEnabled(false);
        } else if (string.equals(TOP)) {
            this.top_button.setEnabled(true);
            this.start_button.setEnabled(true);
            this.stop_button.setEnabled(false);
        } else {
            this.top_button.setEnabled(true);
            this.start_button.setEnabled(true);
            this.stop_button.setEnabled(false);
            this.manual_button.setEnabled(true);
            this.auto_button.setEnabled(true);
        }
        NaveBoard.instance().updateButtonStatus(string);
    }

    private final boolean displayPage(WebNode webNode) {
        Displayer displayer = this.bag.getDisplayer();
        if (displayer == null || !this.do_display) {
            return false;
        }
        URL uRL = this.getNodeURL(webNode);
        boolean bl = displayer.displayPage(uRL);
        if (bl) {
            this.current_url = uRL;
        }
        return bl;
    }

    private final URL getNodeURL(WebNode webNode) {
        if (webNode == null) {
            return null;
        }
        try {
            return webNode.getURL();
        }
        catch (MalformedURLException malformedURLException) {
            ToolBox.warn("Invalid url of " + webNode.toString(), malformedURLException);
            return null;
        }
        catch (Exception exception) {
            if (ToolBox.debug) {
                ToolBox.warn("Can't get url of " + webNode.toString(), exception);
            }
            return null;
        }
    }

    protected final int getNavigationOrder() {
        return this.nave_order;
    }

    protected final void setNavigationOrder(int n) {
        if (this.nave_order == n) {
            return;
        }
        this.nave_order = n;
        this.resetIterator();
    }

    protected final void setDoDisplay(boolean bl) {
        this.do_display = bl;
    }

    protected final boolean getDoDisplay() {
        return this.do_display;
    }

    protected final void setDisplayer(int n) {
        int n2 = this.bag.getDisplayerIndex();
        if (n2 == n) {
            return;
        }
        boolean bl = this.bag.setDisplayer(n);
        if (!bl) {
            MainFrame.inform("Displayer not changed !");
            return;
        }
        Displayer displayer = this.bag.getDisplayer();
        if (displayer == null) {
            this.bag.setDisplayer(n2);
            return;
        }
        try {
            displayer.activate();
            if (this.current_url != null) {
                displayer.displayPage(this.current_url);
            }
        }
        catch (ExecutionException executionException) {
            ErrorWindow.instance().display("Can't activate displayer " + displayer.getName() + " !");
            this.bag.setDisplayer(n2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void positionIterator(WebNode var1_1) {
        this.resetIterator();
        this.getIterator();
        this.former = null;
        if (this.iterator != null) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            var2_2 = (WebNode)this.iterator.next();
            if (var2_2 == var1_1) {
                return;
            }
            this.former = var2_2;
lbl10:
            // 2 sources

            ** while (this.iterator.hasNext())
        }
lbl11:
        // 1 sources

    }

    protected final void resetIterator() {
        this.iterator = null;
    }

    private final void getIterator() {
        if (this.iterator != null) {
            return;
        }
        WebSite webSite = Controller.instance().getWebSite();
        if (webSite == null) {
            return;
        }
        this.iterator = webSite.getIterator(this.nave_order);
    }

    private final int getSleepTime() {
        return this.pause_time * 1000;
    }

    protected final int getPauseTime() {
        return this.pause_time;
    }

    protected final void setPauseTime(int n) {
        this.pause_time = n < 1 ? 1 : n;
        this.timer.setDelay(this.getSleepTime());
        this.timer.setInitialDelay(this.getSleepTime());
    }

    static /* synthetic */ void access$000(NavePane navePane, String string) {
        navePane.processAction(string);
    }

    static /* synthetic */ void access$100(NavePane navePane, boolean bl) {
        navePane.setMode(bl);
    }

    static /* synthetic */ boolean access$200(NavePane navePane) {
        return navePane.manual;
    }
}

