/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JWindow;
import javax.swing.border.CompoundBorder;
import org.demo.webwader.gui.GuiResources;
import org.demo.webwader.gui.MainFrame;
import org.demo.webwader.gui.NaveBoard;
import org.demo.webwader.gui.NavePane;

class NaveBoard
extends JWindow {
    private static NaveBoard nave_board = null;
    protected JButton prev_button;
    private JButton next_button;
    private JRadioButton auto_button;
    private JRadioButton manual_button;
    private GuiResources rsrc;
    private Icon prev_icon;
    private Icon next_icon;
    private Icon start_icon;
    private Icon stop_icon;

    protected static NaveBoard instance() {
        if (nave_board == null) {
            nave_board = new NaveBoard();
        }
        return nave_board;
    }

    private NaveBoard() {
        super(MainFrame.instance());
        this.build();
        class Adapter
        extends WindowAdapter {
            private final /* synthetic */ NaveBoard this$0;

            Adapter(NaveBoard naveBoard) {
                this.this$0 = naveBoard;
            }

            public final void windowClosed(WindowEvent windowEvent) {
                NaveBoard.access$000(this.this$0);
            }

            public final void windowClosing(WindowEvent windowEvent) {
                NaveBoard.access$000(this.this$0);
            }
        }
        this.addWindowListener(new Adapter(this));
    }

    private void build() {
        this.rsrc = GuiResources.instance();
        ((Component)this).setBackground(this.rsrc.getMainBackground());
        this.setForeground(this.rsrc.getMainForeground());
        ((Component)this).setLocation(this.rsrc.get("MiniBoard.X", 5), this.rsrc.get("MiniBoard.Y", 10));
        Color color = this.rsrc.getPaneForeground();
        Color color2 = this.rsrc.getPaneBackground();
        this.prev_icon = this.rsrc.getIcon("previous.gif");
        this.next_icon = this.rsrc.getIcon("next.gif");
        this.start_icon = this.rsrc.getIcon("start.gif");
        this.stop_icon = this.rsrc.getIcon("stop.gif");
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(this.rsrc.getLineBorder(), this.rsrc.getOutBorder());
        JPanel jPanel = new JPanel();
        this.setContentPane(jPanel);
        jPanel.setLayout(new GridLayout(2, 2));
        jPanel.setBackground(color2);
        jPanel.setForeground(color);
        jPanel.setBorder(compoundBorder);
        Insets insets = new Insets(0, 0, 0, 0);
        Dimension dimension = new Dimension(30, 30);
        this.prev_button = new JButton(this.prev_icon);
        this.prev_button.setToolTipText("Go to previous page");
        this.prev_button.setOpaque(false);
        this.prev_button.setBackground(color2);
        this.prev_button.setMargin(insets);
        this.prev_button.setActionCommand("PREV");
        this.prev_button.setPreferredSize(dimension);
        jPanel.add(this.prev_button);
        this.prev_button.addActionListener(NavePane.instance().getNaveListener());
        this.next_button = new JButton(this.next_icon);
        this.next_button.setToolTipText("Go to next page");
        this.next_button.setOpaque(false);
        this.next_button.setBackground(color2);
        this.next_button.setMargin(insets);
        this.next_button.setActionCommand("NEXT");
        this.next_button.setPreferredSize(dimension);
        jPanel.add(this.next_button);
        this.next_button.addActionListener(NavePane.instance().getNaveListener());
        ButtonGroup buttonGroup = new ButtonGroup();
        this.manual_button = new JRadioButton("M");
        this.manual_button.setToolTipText("Set manual mode");
        this.manual_button.setFont(this.rsrc.getTextFont());
        this.manual_button.setOpaque(false);
        this.manual_button.setForeground(color);
        this.manual_button.setHorizontalAlignment(0);
        this.manual_button.addActionListener(NavePane.instance().getModeListener());
        jPanel.add(this.manual_button);
        buttonGroup.add(this.manual_button);
        this.auto_button = new JRadioButton("A");
        this.auto_button.setToolTipText("Set automatic mode");
        this.auto_button.setFont(this.rsrc.getTextFont());
        this.auto_button.setOpaque(false);
        this.auto_button.setForeground(color);
        this.auto_button.setHorizontalAlignment(0);
        this.auto_button.addActionListener(NavePane.instance().getModeListener());
        this.setMode(NavePane.instance().getMode());
        jPanel.add(this.auto_button);
        buttonGroup.add(this.auto_button);
        this.pack();
    }

    protected final void display(boolean bl) {
        MainFrame mainFrame = MainFrame.instance();
        if (bl) {
            ((Component)this).setVisible(mainFrame.getShowMiniBoardState());
        } else {
            ((Component)this).setVisible(false);
            mainFrame.setShowMiniBoardState(false);
        }
    }

    private final void processClose() {
        this.display(false);
    }

    protected final void setMode(boolean bl) {
        if (bl) {
            this.manual_button.setSelected(true);
            this.prev_button.setIcon(this.prev_icon);
            this.prev_button.setToolTipText("Go to previous page");
            this.next_button.setIcon(this.next_icon);
            this.next_button.setToolTipText("Go to next page");
            this.prev_button.setEnabled(true);
            this.next_button.setEnabled(true);
        } else {
            JButton jButton = this.prev_button;
            JButton jButton2 = this.next_button;
            this.auto_button.setSelected(true);
            jButton.setIcon(this.stop_icon);
            jButton.setToolTipText("Stop navigation in progress");
            jButton2.setIcon(this.start_icon);
            jButton2.setToolTipText("Start new navigation");
            jButton2.setEnabled(true);
            jButton.setEnabled(false);
        }
    }

    protected final void updateButtonStatus(String string) {
        JButton jButton = this.prev_button;
        JButton jButton2 = this.next_button;
        if (string.equals("NEXT")) {
            jButton2.setEnabled(false);
            jButton.setEnabled(true);
            this.manual_button.setEnabled(false);
            this.auto_button.setEnabled(false);
        } else {
            jButton2.setEnabled(true);
            jButton.setEnabled(false);
            this.manual_button.setEnabled(true);
            this.auto_button.setEnabled(true);
        }
    }

    static /* synthetic */ void access$000(NaveBoard naveBoard) {
        naveBoard.processClose();
    }
}

