/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import org.ariane.applet.Messenger;
import org.ariane.gui.TimerBar;
import org.ariane.tools.ToolBox;
import org.demo.webwader.gui.Confirmer;
import org.demo.webwader.gui.Controller;
import org.demo.webwader.gui.Displayer;
import org.demo.webwader.gui.DisplayersBag;
import org.demo.webwader.gui.ErrorWindow;
import org.demo.webwader.gui.FileChooser;
import org.demo.webwader.gui.GuiResources;
import org.demo.webwader.gui.HelpWindow;
import org.demo.webwader.gui.NaveBoard;
import org.demo.webwader.gui.NavePane;
import org.demo.webwader.gui.OptionPane;
import org.demo.webwader.gui.ScanWindow;
import org.demo.webwader.gui.SiteFileFilter;
import org.demo.webwader.gui.SwingDisplayer;
import org.demo.webwader.gui.TreePane;
import org.demo.webwader.gui.VersionWindow;

public class MainFrame
extends JFrame
implements ActionListener {
    private static final String OPEN = "Open";
    private static final String SAVE = "Save";
    private static final String SET_OPTIONS = "SetOptions";
    private static final String SAVE_OPTIONS = "SaveOptions";
    private static final String DISPLAY = "Display";
    private static final String SHOW_MINI = "ShowMiniBoard";
    private static final String SCAN = "Scan";
    private static final String QUIT = "Quit";
    private static final String ABOUT = "About WebWader ...";
    private static final String MANUAL = "WebWader short help ...";
    private static final String WADERSITE = "WebWader home page ...";
    private Container window;
    private static Messenger messenger;
    private TimerBar timerbar;
    private GuiResources resources;
    private static MainFrame main_frame;
    private Controller controller;
    private JCheckBoxMenuItem showmini;

    protected static MainFrame instance() {
        if (main_frame == null) {
            main_frame = new MainFrame("WebWader");
        }
        return main_frame;
    }

    protected static final void inform(String string) {
        messenger.display(string);
    }

    protected static final void clearMessage() {
        messenger.erase();
    }

    private MainFrame(String string) {
        super(string);
        ToolBox.dot();
        this.controller = Controller.instance();
        this.resources = GuiResources.instance();
        ToolBox.dot();
        int n = this.resources.get("Width", 800);
        int n2 = this.resources.get("Height", 400);
        ((Component)this).setSize(n, n2);
        JMenuBar jMenuBar = this.buildMenuBar();
        this.setJMenuBar(jMenuBar);
        this.window = this.getContentPane();
        this.window.setLayout(new BoxLayout(this.window, 1));
        this.window.setBackground(this.resources.getMainBackground());
        this.window.setForeground(this.resources.getMainForeground());
        this.window.setFont(this.resources.getHeaderFont());
        JComponent jComponent = this.buildTopPane();
        this.window.add(jComponent);
        ToolBox.dot();
        JComponent jComponent2 = this.buildNavePane();
        this.window.add(jComponent2);
        ToolBox.dot();
        this.window.add(Box.createVerticalStrut(2 * this.resources.getSpace()));
        JComponent jComponent3 = this.buildTreePane();
        this.window.add(jComponent3);
        ToolBox.dot();
        JComponent jComponent4 = this.buildBottomPane();
        this.window.add(jComponent4);
        ToolBox.dot();
        ((Component)this).setVisible(true);
        ToolBox.dot();
        System.out.println();
        MainFrame.inform("Welcome to this new session of Traverser !");
    }

    private JComponent buildTopPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createRigidArea(new Dimension(this.resources.getSpace(), 50)));
        jPanel.setOpaque(false);
        Icon icon = this.resources.getIcon("jvs.gif");
        JLabel jLabel = new JLabel(icon);
        jLabel.setAlignmentX(0.0f);
        jLabel.setBorder(this.resources.getLineBorder());
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalGlue());
        icon = this.resources.getIcon(this.resources.get("Title", "webwader.gif"));
        jLabel = new JLabel(icon);
        jLabel.setOpaque(false);
        jLabel.setAlignmentX(0.5f);
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(40 * this.resources.getSpace(), 0)));
        return jPanel;
    }

    private JComponent buildNavePane() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.resources.getPaneBackground());
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setOpaque(true);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(this.resources.getMatteBorder(), this.resources.getLineBorder());
        jPanel.setBorder(compoundBorder);
        NavePane navePane = NavePane.instance();
        navePane.setAlignmentX(0.0f);
        jPanel.add(navePane);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    private JComponent buildTreePane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentX(0.5f);
        jPanel.setOpaque(false);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(this.resources.getMatteBorder(), this.resources.getLineBorder());
        jPanel.setBorder(compoundBorder);
        ToolBox.dot();
        TreePane treePane = TreePane.instance();
        ToolBox.dot();
        JScrollPane jScrollPane = new JScrollPane(treePane);
        jPanel.add(jScrollPane);
        return jPanel;
    }

    private JComponent buildBottomPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.setOpaque(false);
        JComponent jComponent = this.buildTimerBar();
        jPanel.add(jComponent);
        JComponent jComponent2 = this.buildMessageArea();
        jPanel.add(jComponent2);
        return jPanel;
    }

    private JComponent buildTimerBar() {
        TimerBar timerBar = new TimerBar();
        timerBar.setPeriod(this.resources.get("TimerPeriod", 100));
        timerBar.setBackground(this.resources.getPaneBackground());
        timerBar.setForeground(this.resources.get("TimerColor", Color.red));
        timerBar.setBorder(this.resources.getInBorder());
        this.timerbar = timerBar;
        return timerBar;
    }

    protected final void startTimer(int n) {
        this.timerbar.start(n);
    }

    protected final void stopTimer() {
        this.timerbar.stop();
    }

    private JComponent buildMessageArea() {
        JLabel jLabel = new JLabel();
        jLabel.setBackground(this.resources.getMainBackground());
        jLabel.setForeground(this.resources.getMainForeground());
        jLabel.setFont(this.resources.getTextFont());
        ToolBox.dot();
        messenger = new Messenger(jLabel);
        messenger.setDisplayTime(this.resources.get("DisplayTime", 5));
        return jLabel;
    }

    private JMenuBar buildMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        Color color = this.resources.getMainForeground();
        Color color2 = this.resources.getMainBackground();
        jMenuBar.setBackground(color2);
        jMenuBar.setForeground(color);
        JMenu jMenu = new JMenu("File");
        jMenu.setToolTipText("To execute main operations");
        jMenu.setOpaque(false);
        jMenu.setForeground(color);
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Open file ...");
        jMenuItem.setActionCommand(OPEN);
        this.setMenuItem(jMenuItem);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Scan site ...");
        jMenuItem.setActionCommand(SCAN);
        this.setMenuItem(jMenuItem);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save as ...");
        jMenuItem.setActionCommand(SAVE);
        this.setMenuItem(jMenuItem);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(QUIT);
        jMenuItem.setActionCommand(QUIT);
        this.setMenuItem(jMenuItem);
        jMenu.addSeparator();
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Settings");
        jMenu.setOpaque(false);
        jMenu.setForeground(color);
        jMenu.setToolTipText("To change current configuration");
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("Set options ...");
        jMenuItem.setActionCommand(SET_OPTIONS);
        this.setMenuItem(jMenuItem);
        jMenuItem.setToolTipText("To set various parameters");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save options ...");
        jMenuItem.setActionCommand(SAVE_OPTIONS);
        this.setMenuItem(jMenuItem);
        jMenuItem.setToolTipText("To save the current setting");
        jMenu.add(jMenuItem);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Display Pages");
        jCheckBoxMenuItem.setActionCommand(DISPLAY);
        jCheckBoxMenuItem.setState(this.resources.get("DoDisplay", true));
        this.setMenuItem(jCheckBoxMenuItem);
        jCheckBoxMenuItem.setToolTipText("To actually display web pages");
        jMenu.add(jCheckBoxMenuItem);
        this.processDoDisplay(jCheckBoxMenuItem.getState());
        this.showmini = new JCheckBoxMenuItem("Show MiniBoard");
        this.showmini.setActionCommand(SHOW_MINI);
        this.showmini.setState(this.resources.get(SHOW_MINI, false));
        this.setMenuItem(this.showmini);
        this.showmini.setToolTipText("To open the mini navigation board");
        jMenu.add(this.showmini);
        jMenu = new JMenu("Help");
        jMenu.setOpaque(false);
        jMenu.setForeground(color);
        jMenuBar.add(jMenu);
        jMenu.setToolTipText("To get information about WebWader");
        jMenuItem = new JMenuItem(MANUAL);
        jMenuItem.setToolTipText("Where to find documentation");
        jMenu.add(jMenuItem);
        this.setMenuItem(jMenuItem);
        jMenuItem = new JMenuItem(WADERSITE);
        jMenuItem.setToolTipText("Connect to WebWader home page");
        jMenu.add(jMenuItem);
        this.setMenuItem(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(ABOUT);
        jMenuItem.setToolTipText("To find out current version");
        jMenu.add(jMenuItem);
        this.setMenuItem(jMenuItem);
        return jMenuBar;
    }

    private final void setMenuItem(JMenuItem jMenuItem) {
        jMenuItem.addActionListener(this);
        jMenuItem.setBackground(this.resources.getMainBackground());
        jMenuItem.setForeground(this.resources.getMainForeground());
    }

    protected final boolean getShowMiniBoardState() {
        return this.showmini.getState();
    }

    protected final void setShowMiniBoardState(boolean bl) {
        this.showmini.setState(bl);
    }

    public String toString() {
        return "MainFrame " + this.getName();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(QUIT)) {
            this.processQuit();
        } else if (string.equals(OPEN)) {
            this.processOpen();
        } else if (string.equals(SCAN)) {
            this.processScan();
        } else if (string.equals(SAVE)) {
            this.processSave();
        } else if (string.equals(SET_OPTIONS)) {
            this.processSetOptions();
        } else if (string.equals(SAVE_OPTIONS)) {
            this.processSaveOptions();
        } else if (string.equals(DISPLAY)) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            this.processDoDisplay(jCheckBoxMenuItem.getState());
        } else if (string.equals(SHOW_MINI)) {
            this.processShowMiniBoard(this.showmini.getState());
        } else if (string.equals(ABOUT)) {
            this.processAbout();
        } else if (string.equals(MANUAL)) {
            this.processManual();
        } else if (string.equals(WADERSITE)) {
            this.processWaderSite();
        } else {
            ToolBox.warn("Invalid command " + string);
        }
    }

    private final void processQuit() {
        if (Controller.instance().isSiteNotSaved() && Confirmer.instance().ask("Save current site before ?")) {
            this.processSave();
        }
        if (Confirmer.instance().ask("Really want to quit ?")) {
            ToolBox.warn("See you later");
            System.exit(0);
        }
    }

    private final void processOpen() {
        FileChooser fileChooser = FileChooser.instance();
        fileChooser.setDialogTitle("Open file");
        fileChooser.setFileFilter(SiteFileFilter.instance());
        fileChooser.setMultiSelectionEnabled(false);
        int n = FileChooser.instance().display(OPEN);
        if (n != 0) {
            return;
        }
        this.controller.start(1);
    }

    protected final void processSave() {
        FileChooser fileChooser = FileChooser.instance();
        fileChooser.setDialogTitle("Save file");
        fileChooser.setFileFilter(SiteFileFilter.instance());
        fileChooser.setMultiSelectionEnabled(false);
        int n = FileChooser.instance().display(SAVE);
        if (n != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        if (file.exists() && !Confirmer.instance().ask("Overwrite " + file.getName() + " ?")) {
            return;
        }
        this.controller.start(2);
    }

    private final void processSetOptions() {
        OptionPane.instance().display();
    }

    private final void processSaveOptions() {
        OptionPane.instance().save();
    }

    private final void processDoDisplay(boolean bl) {
        NavePane.instance().setDoDisplay(bl);
    }

    private final void processShowMiniBoard(boolean bl) {
        ((Component)NaveBoard.instance()).setVisible(bl);
    }

    private final void processScan() {
        ScanWindow.instance().display();
    }

    private final void processAbout() {
        VersionWindow.instance().display();
    }

    private final void processManual() {
        HelpWindow.instance().display();
    }

    private final void processWaderSite() {
        Displayer displayer = DisplayersBag.instance().getDisplayer();
        if (displayer == null) {
            displayer = SwingDisplayer.instance();
        }
        try {
            URL uRL = new URL("http://jeanpaul.lefevre.free.fr/java/webwader/index.html");
            displayer.displayPage(uRL);
        }
        catch (Exception exception) {
            ErrorWindow.instance().display("Can't show WebWader home page !");
        }
    }

    static {
        main_frame = null;
    }
}

