/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.gui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.ariane.exec.ExecutionException;
import org.ariane.tools.ToolBox;
import org.demo.webwader.Resources;
import org.demo.webwader.gui.AbstractDisplayer;
import org.demo.webwader.gui.ErrorWindow;
import org.demo.webwader.gui.GuiResources;

class Konqueror
extends AbstractDisplayer {
    private static Konqueror displayer = null;
    private String command = null;
    protected static final String NAME = "Konqueror";

    Konqueror() {
    }

    protected static Konqueror instance() {
        if (displayer == null) {
            displayer = new Konqueror();
        }
        return displayer;
    }

    public final void activate() {
        String string = "";
        try {
            this.prepareCommand();
            string = this.getCommand(GuiResources.getWelcomeLocation());
            Process process = Runtime.getRuntime().exec(string);
            int n = 0;
            try {
                n = process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return;
            }
            ErrorWindow.instance().display("Can't activate Konqueror !");
            if (ToolBox.debug) {
                ToolBox.warn(string + " rc : " + n);
            }
        }
        catch (Exception exception) {
            ErrorWindow.instance().display("Can't activate Konqueror !\nCheck if it is running and try again.");
            ToolBox.warn("Can't activate Konqueror", exception);
            throw new ExecutionException("Konqueror activation failed");
        }
    }

    public final String getName() {
        return NAME;
    }

    public final boolean displayPage(URL uRL) {
        String string = "";
        try {
            if (!this.isToShow(uRL)) {
                return false;
            }
            string = this.getCommand(uRL.toExternalForm());
            Process process = Runtime.getRuntime().exec(string);
            int n = process.waitFor();
            if (n != 0) {
                ErrorWindow.instance().display("Can't run Konqueror !\nCheck if it is running.");
                return false;
            }
        }
        catch (Exception exception) {
            ToolBox.warn("Can't display page with Konqueror", exception);
            ToolBox.warn("Command : " + string);
            if (ToolBox.debug) {
                exception.printStackTrace();
            }
            return false;
        }
        return true;
    }

    private final String getCommand(String string) {
        if (this.command == null) {
            throw new ExecutionException("Invalid null command");
        }
        return this.command + string;
    }

    private final void prepareCommand() {
        String string = Resources.instance().get("Konqueror.MainWindow");
        if (string == null) {
            string = this.getWindowId();
        } else if (ToolBox.debug) {
            this.listWindowIds();
            System.out.println(string + " is selected");
        }
        this.command = "dcop konqueror " + string + " openURL ";
    }

    private final String getWindowId() {
        String string = "";
        try {
            string = "dcop konqueror default getWindows";
            Process process = Runtime.getRuntime().exec(string);
            if (process.waitFor() != 0) {
                throw new ExecutionException("Job " + string + " failed");
            }
            string = "dcop konqueror";
            process = Runtime.getRuntime().exec(string);
            if (process.waitFor() != 0) {
                throw new ExecutionException("Job " + string + " failed");
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            bufferedReader.readLine();
            String string2 = bufferedReader.readLine();
            if (string2 == null || !string2.startsWith("0x")) {
                throw new ExecutionException("Invalid window address : " + string2);
            }
            return string2;
        }
        catch (InterruptedException interruptedException) {
            throw new ExecutionException("For " + string + " " + interruptedException.getMessage());
        }
        catch (IOException iOException) {
            throw new ExecutionException("For " + string + " " + iOException.getMessage());
        }
    }

    private final void listWindowIds() {
        try {
            String string = "dcop konqueror default getWindows";
            Process process = Runtime.getRuntime().exec(string);
            if (process.waitFor() != 0) {
                ToolBox.warn("Job " + string + " failed");
                return;
            }
            string = "dcop konqueror";
            process = Runtime.getRuntime().exec(string);
            if (process.waitFor() != 0) {
                ToolBox.warn("Job " + string + " failed");
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            System.out.println("List of Known windows :");
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                System.out.println(string2);
                string2 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            ToolBox.warn("Can't get list of konqueror windows", exception);
        }
    }
}

