/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.gui;

import java.net.URL;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.ariane.exec.ExecutionException;
import org.ariane.tools.ToolBox;
import org.demo.webwader.Resources;
import org.demo.webwader.gui.AbstractDisplayer;
import org.demo.webwader.gui.ErrorWindow;
import org.demo.webwader.rbi.RemoteDisplayer;

abstract class JavaDisplayer
extends AbstractDisplayer {
    protected RemoteDisplayer displayer = null;

    JavaDisplayer() {
    }

    public final String getRemoteName() {
        try {
            return this.displayer.getName();
        }
        catch (Exception exception) {
            if (ToolBox.debug) {
                ToolBox.warn("Can't get name of displayer", exception);
            }
            return null;
        }
    }

    private final void getServant() {
        try {
            Resources resources = (Resources)Resources.instance();
            int n = resources.get(".Registry.Port", 1099);
            Registry registry = LocateRegistry.getRegistry(n);
            this.displayer = (RemoteDisplayer)registry.lookup("//localhost/RemoteDisplayer");
        }
        catch (Exception exception) {
            ToolBox.warn("Can't create remote displayer", exception);
            ErrorWindow.instance().display("Can't create remote displayer !\nCheck if the server is running and try again.");
        }
    }

    public final void activate() {
        try {
            boolean bl = true;
            if (this.displayer == null) {
                bl = false;
                this.getServant();
            }
            if (this.displayer.changeDisplayer(this.getName())) {
                this.displayer.activate();
            } else if (bl) {
                ErrorWindow.instance().display("Can't install remote " + this.getName() + " !\n" + "Check if this displayer is available.");
            }
        }
        catch (Exception exception) {
            ToolBox.warn("Can't activate remote displayer", exception);
            ErrorWindow.instance().display("Can't activate remote " + this.getName() + " !\n" + "Check if this displayer is available.");
            this.displayer = null;
            throw new ExecutionException("Remote displayer activation failed");
        }
    }

    public final boolean displayPage(URL uRL) {
        try {
            if (!this.isToShow(uRL)) {
                return false;
            }
            this.displayer.displayPage(uRL);
        }
        catch (Exception exception) {
            ToolBox.warn("Can't display page with " + this.getName(), exception);
            ErrorWindow.instance().display("Can't display page with " + this.getName() + " !\n" + "Check if the connection is still alive.");
            return false;
        }
        return true;
    }
}

