/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.gui;

import java.net.URL;
import org.ariane.exec.ExecutionException;
import org.ariane.tools.ToolBox;
import org.demo.webwader.gui.AbstractDisplayer;
import org.demo.webwader.gui.ErrorWindow;
import org.demo.webwader.gui.GuiResources;

class IExplorerUnix
extends AbstractDisplayer {
    private static IExplorerUnix displayer = null;
    private static final String IE5 = "iexplorer";
    protected static final String NAME = "IExplorer";

    IExplorerUnix() {
    }

    protected static IExplorerUnix instance() {
        if (displayer == null) {
            displayer = new IExplorerUnix();
        }
        return displayer;
    }

    public final void activate() {
        String string = GuiResources.getWelcomeLocation();
        StringBuffer stringBuffer = new StringBuffer(IE5).append(" -remote ");
        stringBuffer.append(string);
        String string2 = stringBuffer.toString();
        try {
            Process process = Runtime.getRuntime().exec(string2);
            int n = 1;
            try {
                n = process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return;
            }
            if (n == 0) {
                return;
            }
            ErrorWindow.instance().display("Can't launch IExplorer !");
            if (ToolBox.debug) {
                ToolBox.warn(string2 + " rc : " + n);
            }
        }
        catch (Exception exception) {
            ToolBox.warn("Can't activate IExplorer", exception);
            ErrorWindow.instance().display("Can't activate IExplorer !\nCheck if it is available on your system.");
            throw new ExecutionException("IExplorer activation failed");
        }
    }

    public final String getName() {
        return NAME;
    }

    public final boolean displayPage(URL uRL) {
        try {
            if (!this.isToShow(uRL)) {
                return false;
            }
            String string = "iexplorer -remote " + uRL.toExternalForm();
            Process process = Runtime.getRuntime().exec(string);
            int n = process.waitFor();
            if (n != 0) {
                ErrorWindow.instance().display("Can't run IExplorer !\nCheck if it is running.");
                return false;
            }
        }
        catch (Exception exception) {
            ToolBox.warn("Can't display page thru IExplorer", exception);
            exception.printStackTrace();
            return false;
        }
        return true;
    }
}

