/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.gui;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.ariane.exec.ExecutionException;
import org.ariane.tools.ToolBox;
import org.demo.webwader.Resources;
import org.demo.webwader.gui.AbstractDisplayer;
import org.demo.webwader.gui.ErrorWindow;
import org.demo.webwader.gui.GuiResources;

class EmacsW3
extends AbstractDisplayer {
    private String command = this.getPath();
    private static EmacsW3 displayer = null;
    protected static final String NAME = "Emacs";
    private static String EQ = ToolBox.isUnderWindows() ? "\\\"" : "\"";

    protected static EmacsW3 instance() {
        if (displayer == null) {
            displayer = new EmacsW3();
        }
        return displayer;
    }

    protected EmacsW3() {
        File file = new File(this.command);
        if (!file.exists()) {
            ToolBox.warn("Can't find " + this.command);
            this.command = null;
            return;
        }
        this.command = this.command + ' ' + this.getOptions() + ' ';
    }

    private final String getCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.command);
        stringBuffer.append("(w3-fetch ").append(EQ).append(string).append(EQ).append(')');
        return stringBuffer.toString();
    }

    public final void activate() {
        String string = "";
        try {
            string = this.getCommand(GuiResources.getWelcomeLocation());
            Process process = Runtime.getRuntime().exec(string);
            int n = 0;
            try {
                n = process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return;
            }
            ErrorWindow.instance().display("Can't launch " + string + " !");
            if (ToolBox.debug) {
                ToolBox.warn(string + " rc : " + n);
            }
        }
        catch (IOException iOException) {
            ErrorWindow.instance().display("Can't run " + this.getName() + " !\nCheck " + this.getPath());
            if (ToolBox.debug) {
                ToolBox.warn("Can't run " + string, iOException);
            }
            throw new ExecutionException("Emacs activation failed");
        }
        catch (Exception exception) {
            ToolBox.warn("Can't activate " + this.getName(), exception);
            if (ToolBox.debug) {
                exception.printStackTrace();
            }
            throw new ExecutionException("Emacs activation failed");
        }
    }

    public final boolean displayPage(URL uRL) {
        try {
            if (!this.isToShow(uRL)) {
                return false;
            }
            String string = this.getCommand(uRL.toExternalForm());
            Process process = Runtime.getRuntime().exec(string);
            int n = process.waitFor();
            if (n != 0) {
                if (ToolBox.debug) {
                    ToolBox.warn(string + " rc : " + n);
                }
                ErrorWindow.instance().display("Can't run " + this.getName() + " !\nCheck if it is running.");
            }
        }
        catch (Exception exception) {
            ToolBox.warn("Can't display page with " + this.command, exception);
            if (ToolBox.debug) {
                exception.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public final String getName() {
        return NAME;
    }

    public final String getPath() {
        return Resources.instance().get("EmacsW3.Path", "/usr/local/bin/gnudoit");
    }

    protected final String getOptions() {
        return "-q";
    }
}

