/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.gui;

import java.awt.Component;
import org.ariane.tools.ToolBox;
import org.demo.webwader.gui.AbstractDisplayersBag;
import org.demo.webwader.gui.ClueDisplayer;
import org.demo.webwader.gui.EmacsW3;
import org.demo.webwader.gui.Galeon;
import org.demo.webwader.gui.HorstDisplayer;
import org.demo.webwader.gui.IExplorerUnix;
import org.demo.webwader.gui.IExplorerWindows;
import org.demo.webwader.gui.IceDisplayer;
import org.demo.webwader.gui.Konqueror;
import org.demo.webwader.gui.MozillaUnix;
import org.demo.webwader.gui.MozillaWindows;
import org.demo.webwader.gui.NeoPlanet;
import org.demo.webwader.gui.NetscapeUnix;
import org.demo.webwader.gui.NetscapeWindows;
import org.demo.webwader.gui.OperaUnix;
import org.demo.webwader.gui.OperaWindows;
import org.demo.webwader.gui.PrintURL;
import org.demo.webwader.gui.RemoteSwingDisplayer;
import org.demo.webwader.gui.SkipStone;
import org.demo.webwader.gui.SocketDisplayer;
import org.demo.webwader.gui.SwingDisplayer;
import org.demo.webwader.gui.WebWindow;
import org.demo.webwader.gui.XmlDisplayer;

class DisplayersBag
extends AbstractDisplayersBag {
    private static DisplayersBag bag = null;
    private static final int LOCAL_SWING = 0;
    private static final int NETSCAPE = 1;
    private static final int IEXPLORER = 2;
    private static final int MOZILLA = 3;
    private static final int EMACS = 4;
    private static final int PRINT_URL = 5;
    private static final int RBI_SWING = 6;
    private static final int ICE = 7;
    private static final int CLUE = 8;
    private static final int HORST = 9;
    private static final int XMLRPC = 10;
    private static final int OPERA = 11;
    private static final int NEOPLANET = 12;
    private static final int KONQUEROR = 12;
    private static final int GALEON = 13;
    private static final int SKIPSTONE = 14;
    private static final int SOCKET = 15;

    private DisplayersBag() {
        if (ToolBox.isUnderUnix()) {
            this.DISPLAYERS = new String[16];
            this.DISPLAYERS[12] = "Konqueror";
            this.DISPLAYERS[13] = "Galeon";
            this.DISPLAYERS[14] = "SkipStone";
            this.DISPLAYERS[15] = "Amaya";
        } else if (ToolBox.isUnderWindows()) {
            this.DISPLAYERS = new String[13];
            this.DISPLAYERS[12] = "NeoPlanet";
        } else {
            this.DISPLAYERS = new String[1];
        }
        this.DISPLAYERS[0] = "LocalSwing";
        this.DISPLAYERS[1] = "Netscape";
        this.DISPLAYERS[3] = "Mozilla";
        this.DISPLAYERS[11] = "Opera";
        this.DISPLAYERS[4] = "Emacs";
        this.DISPLAYERS[5] = "PrintURL";
        this.DISPLAYERS[2] = "IExplorer";
        this.DISPLAYERS[6] = "RemoteSwing";
        this.DISPLAYERS[10] = "XBrowser";
        this.DISPLAYERS[7] = "IceDisplayer";
        this.DISPLAYERS[8] = "ClueDisplayer";
        this.DISPLAYERS[9] = "HorstDisplayer";
    }

    protected static DisplayersBag instance() {
        if (bag == null) {
            bag = new DisplayersBag();
        }
        return bag;
    }

    protected final boolean setDisplayer(int n) {
        if (n != 0) {
            ((Component)WebWindow.instance()).setVisible(false);
        }
        boolean bl = false;
        if (ToolBox.isUnderUnix()) {
            bl = this.setUnixDisplayer(n);
        } else if (ToolBox.isUnderWindows()) {
            bl = this.setWindowsDisplayer(n);
        }
        if (ToolBox.debug) {
            if (this.displayer == null) {
                ToolBox.warn("Displayer undefined");
            } else {
                ToolBox.warn("Displayer : " + this.displayer.getName());
            }
        }
        return bl;
    }

    private final boolean setWindowsDisplayer(int n) {
        switch (n) {
            case 0: {
                this.displayer = SwingDisplayer.instance();
                break;
            }
            case 6: {
                this.displayer = RemoteSwingDisplayer.instance();
                break;
            }
            case 1: {
                this.displayer = NetscapeWindows.instance();
                break;
            }
            case 3: {
                this.displayer = MozillaWindows.instance();
                break;
            }
            case 4: {
                this.displayer = EmacsW3.instance();
                break;
            }
            case 5: {
                this.displayer = PrintURL.instance();
                break;
            }
            case 2: {
                this.displayer = IExplorerWindows.instance();
                break;
            }
            case 11: {
                this.displayer = OperaWindows.instance();
                break;
            }
            case 12: {
                this.displayer = NeoPlanet.instance();
                break;
            }
            case 7: {
                this.displayer = IceDisplayer.instance();
                break;
            }
            case 8: {
                this.displayer = ClueDisplayer.instance();
                break;
            }
            case 9: {
                this.displayer = HorstDisplayer.instance();
                break;
            }
            case 10: {
                this.displayer = XmlDisplayer.instance();
                break;
            }
            default: {
                ToolBox.warn("Displayer unknown : " + n);
                return false;
            }
        }
        return true;
    }

    private final boolean setUnixDisplayer(int n) {
        switch (n) {
            case 0: {
                this.displayer = SwingDisplayer.instance();
                break;
            }
            case 6: {
                this.displayer = RemoteSwingDisplayer.instance();
                break;
            }
            case 5: {
                this.displayer = PrintURL.instance();
                break;
            }
            case 1: {
                this.displayer = NetscapeUnix.instance();
                break;
            }
            case 3: {
                this.displayer = MozillaUnix.instance();
                break;
            }
            case 11: {
                this.displayer = OperaUnix.instance();
                break;
            }
            case 2: {
                this.displayer = IExplorerUnix.instance();
                break;
            }
            case 4: {
                this.displayer = EmacsW3.instance();
                break;
            }
            case 12: {
                this.displayer = Konqueror.instance();
                break;
            }
            case 13: {
                this.displayer = Galeon.instance();
                break;
            }
            case 15: {
                this.displayer = SocketDisplayer.instance();
                break;
            }
            case 14: {
                this.displayer = SkipStone.instance();
                break;
            }
            case 7: {
                this.displayer = IceDisplayer.instance();
                break;
            }
            case 8: {
                this.displayer = ClueDisplayer.instance();
                break;
            }
            case 9: {
                this.displayer = HorstDisplayer.instance();
                break;
            }
            case 10: {
                this.displayer = XmlDisplayer.instance();
                break;
            }
            default: {
                ToolBox.warn("Displayer unknown : " + n);
                return false;
            }
        }
        return true;
    }
}

