/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.gui;

import java.io.File;
import java.io.IOException;
import org.ariane.exec.RunnableTask;
import org.ariane.tools.InvalidDataException;
import org.ariane.tools.ToolBox;
import org.demo.webwader.BadConfigurationException;
import org.demo.webwader.Resources;
import org.demo.webwader.WebSite;
import org.demo.webwader.XmlLoader;
import org.demo.webwader.gui.Confirmer;
import org.demo.webwader.gui.ErrorWindow;
import org.demo.webwader.gui.FileChooser;
import org.demo.webwader.gui.MainFrame;
import org.demo.webwader.gui.NaveBoard;
import org.demo.webwader.gui.NavePane;
import org.demo.webwader.gui.TreePane;

public class Controller
extends RunnableTask {
    private static Controller controller = null;
    protected static final int NOOP = -1;
    protected static final int OPEN = 1;
    protected static final int SAVE = 2;
    protected static final int CLOSE = 3;
    private Integer command = new Integer(-1);
    private WebSite site = null;
    private boolean notsaved = false;

    private Controller() {
        super("Controller");
    }

    protected static Controller instance() {
        if (controller == null) {
            controller = new Controller();
        }
        return controller;
    }

    protected final WebSite getWebSite() {
        return this.site;
    }

    protected final void setNewWebSite(WebSite webSite) {
        this.setWebSite(webSite);
        this.notsaved = true;
        NaveBoard.instance().display(true);
    }

    protected final void setWebSite(WebSite webSite) {
        if (this.site != null && this.site != webSite && this.notsaved && Confirmer.instance().ask("Save current site before ?")) {
            MainFrame.instance().processSave();
        }
        this.site = webSite;
        this.notsaved = false;
        NaveBoard.instance().display(true);
        TreePane.instance().displaySiteMap(webSite);
        NavePane.instance().resetIterator();
    }

    private final void saveFile() throws IOException {
        String string;
        if (this.site == null) {
            throw new InvalidDataException("Can't save null site");
        }
        File file = FileChooser.instance().getSelectedFile();
        String string2 = string = file.getPath();
        int n = string.lastIndexOf(".site");
        if (n < 0) {
            n = string.lastIndexOf(".xml");
        }
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        this.site.write(string2 + ".site");
        this.notsaved = false;
        if (Resources.instance().get("WebWader.XML.Save", ToolBox.hasXML())) {
            String string3 = string2 + ".xml";
            this.site.writeXML(string3);
        }
    }

    private final void openFile() throws IOException {
        this.openFile(FileChooser.instance().getSelectedFile());
    }

    protected final boolean isSiteNotSaved() {
        return this.notsaved;
    }

    protected final void openFile(File file) throws IOException {
        String string = file.getPath();
        String string2 = file.getName();
        int n = string2.lastIndexOf(".site");
        WebSite webSite = null;
        if (n > 0) {
            string2 = string2.substring(0, n);
            webSite = new WebSite(string2);
            webSite.read(string);
        } else {
            n = string2.lastIndexOf(".xml");
            if (n > 0 && ToolBox.hasXML()) {
                webSite = XmlLoader.instance().loadSite(string);
            } else {
                throw new IOException("Unknow file type " + string2);
            }
        }
        this.setWebSite(webSite);
    }

    protected final void start(int n) {
        Integer n2 = this.command;
        synchronized (n2) {
            this.command = new Integer(n);
            this.done = false;
        }
        this.start();
    }

    public void run() {
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            switch (this.command) {
                case -1: {
                    ToolBox.warn("No Op command : " + this.command);
                    break;
                }
                case 1: {
                    MainFrame.inform("Opening file ...");
                    this.openFile();
                    break;
                }
                case 2: {
                    MainFrame.inform("Saving to file ...");
                    this.saveFile();
                    break;
                }
                default: {
                    ToolBox.warn("Unknown command : " + this.command);
                    break;
                }
            }
        }
        catch (IOException iOException) {
            ErrorWindow.instance().display("Can't process file !", iOException);
        }
        catch (BadConfigurationException badConfigurationException) {
            ErrorWindow.instance().display("Bad configuration !", badConfigurationException);
        }
        catch (Exception exception) {
            ErrorWindow.instance().display(exception.getClass().getName() + " !", exception);
        }
        this.done = true;
        MainFrame.clearMessage();
    }
}

