/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.gui;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.ariane.exec.ExecutionException;
import org.ariane.tools.ToolBox;
import org.demo.webwader.Resources;
import org.demo.webwader.gui.AbstractDisplayer;
import org.demo.webwader.gui.ErrorWindow;

abstract class BrowserWindows
extends AbstractDisplayer {
    private String command = null;

    protected BrowserWindows() {
        String string = Resources.instance().getBinDirectory();
        this.command = string + "open_url.exe";
        File file = new File(this.command);
        if (!file.exists()) {
            ToolBox.warn("Can't find " + this.command);
            this.command = null;
            return;
        }
        this.command = this.command + ' ' + this.getOptions() + ' ';
    }

    public abstract String getPath();

    public abstract String getName();

    protected abstract String getOptions();

    private final String getCommand() {
        return this.command;
    }

    public final void activate() {
        StringBuffer stringBuffer = new StringBuffer(Resources.instance().getBinDirectory());
        stringBuffer.append("activate.exe ").append(this.getName());
        String string = "";
        try {
            Process process = Runtime.getRuntime().exec(stringBuffer.toString());
            int n = process.waitFor();
            if (n == 0) {
                return;
            }
            Resources resources = (Resources)Resources.instance();
            stringBuffer = new StringBuffer(this.getPath());
            stringBuffer.append(' ').append(Resources.getWelcomeLocation());
            string = stringBuffer.toString();
            process = Runtime.getRuntime().exec(string);
            try {
                n = process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return;
            }
            ErrorWindow.instance().display("Can't launch " + string + " !");
            if (ToolBox.debug) {
                ToolBox.warn(stringBuffer.toString() + " rc : " + n);
            }
        }
        catch (IOException iOException) {
            ErrorWindow.instance().display("Can't run " + this.getName() + " !\nCheck " + this.getPath());
            if (ToolBox.debug) {
                ToolBox.warn("Can't run " + string, iOException);
            }
            throw new ExecutionException("Browser activation failed");
        }
        catch (Exception exception) {
            ToolBox.warn("Can't activate " + this.getName(), exception);
            if (ToolBox.debug) {
                exception.printStackTrace();
            }
            throw new ExecutionException("Browser activation failed");
        }
    }

    public final boolean displayPage(URL uRL) {
        try {
            if (!this.isToShow(uRL)) {
                return false;
            }
            Process process = Runtime.getRuntime().exec(this.getCommand() + uRL.toExternalForm());
            int n = process.waitFor();
            if (n != 0) {
                if (ToolBox.debug) {
                    ToolBox.warn(this.getCommand() + " rc : " + n);
                }
                ErrorWindow.instance().display("Can't run " + this.getName() + " !\nCheck if it is running.");
            }
        }
        catch (Exception exception) {
            ToolBox.warn("Can't display page with " + this.getCommand(), exception);
            if (ToolBox.debug) {
                exception.printStackTrace();
            }
            return false;
        }
        return true;
    }
}

