/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.gui;

import java.net.URL;
import org.ariane.exec.ExecutionException;
import org.ariane.tools.ToolBox;
import org.demo.webwader.gui.AbstractDisplayer;
import org.demo.webwader.gui.ErrorWindow;
import org.demo.webwader.gui.GuiResources;

abstract class AbstractMozillaUnix
extends AbstractDisplayer {
    AbstractMozillaUnix() {
    }

    protected abstract String getCommand();

    public void activate() {
        String string = GuiResources.getWelcomeLocation();
        StringBuffer stringBuffer = new StringBuffer(this.getCommand()).append("-remote openURL(");
        stringBuffer.append(string).append(")");
        String string2 = stringBuffer.toString();
        try {
            Process process = Runtime.getRuntime().exec(string2);
            int n = process.waitFor();
            if (n == 0) {
                return;
            }
            if (ToolBox.verbose) {
                ToolBox.warn("Launching the browser ...");
            }
            stringBuffer = new StringBuffer(this.getCommand()).append(string);
            string2 = stringBuffer.toString();
            process = Runtime.getRuntime().exec(string2);
            try {
                n = process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                Thread.sleep(3000L);
                return;
            }
            ErrorWindow.instance().display("Can't launch the browser !");
            if (ToolBox.debug) {
                ToolBox.warn(string2 + " rc : " + n);
            }
        }
        catch (Exception exception) {
            ToolBox.warn("Can't activate the browser", exception);
            if (ToolBox.debug) {
                exception.printStackTrace();
            }
            throw new ExecutionException("Browser activation failed");
        }
    }

    public final boolean displayPage(URL uRL) {
        try {
            if (!this.isToShow(uRL)) {
                return false;
            }
            String string = this.getCommand() + "-remote openURL(" + uRL.toExternalForm() + ")";
            Process process = Runtime.getRuntime().exec(string);
            int n = process.waitFor();
            if (n != 0) {
                ErrorWindow.instance().display("Can't run the browser !\nCheck if it is running.");
                return false;
            }
        }
        catch (Exception exception) {
            ToolBox.warn("Can't display page thru the browser", exception);
            exception.printStackTrace();
            return false;
        }
        return true;
    }
}

