/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader;

import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import org.ariane.tools.Nobject;
import org.ariane.tools.ToolBox;
import org.demo.webwader.BadConfigurationException;
import org.demo.webwader.InvalidDataException;
import org.demo.webwader.Resources;
import org.demo.webwader.VersionInfo;
import org.demo.webwader.WebSite;
import org.demo.webwader.XmlHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserFactory;

public class XmlLoader
extends Nobject {
    private static XmlLoader loader = null;
    private String filename;

    public static void main(String[] stringArray) {
        XmlLoader xmlLoader = XmlLoader.instance();
        if (!ToolBox.hasXML()) {
            ToolBox.warn("Can't find XML classes");
            return;
        }
        if (!xmlLoader.parseArg(stringArray)) {
            ToolBox.warn("Can't parse command line");
            return;
        }
        if (!xmlLoader.run()) {
            ToolBox.warn("Can't run " + xmlLoader.getName());
            return;
        }
    }

    private XmlLoader() {
        super("XmlLoader");
    }

    public static XmlLoader instance() {
        if (loader == null) {
            loader = new XmlLoader();
        }
        return loader;
    }

    public boolean run() {
        try {
            if (ToolBox.verbose) {
                ToolBox.warn("Reading from " + this.filename);
            }
            WebSite webSite = this.loadSite(this.filename);
            String string = ToolBox.markAsTemp(this.filename);
            webSite.writeXML(string);
            string = webSite.getName() + ".site~";
            webSite.write(string);
        }
        catch (IOException iOException) {
            if (ToolBox.debug) {
                iOException.printStackTrace();
            }
            ToolBox.warn("Can't read or write site", iOException);
            return false;
        }
        catch (Exception exception) {
            if (ToolBox.debug) {
                exception.printStackTrace();
            }
            ToolBox.warn("Can't handle site", exception);
            return false;
        }
        return true;
    }

    public final WebSite loadSite(String string) throws IOException {
        Parser parser = null;
        WebSite webSite = new WebSite();
        String string2 = "org.xml.sax.parser";
        String string3 = Resources.instance().getProperties().getProperty(string2);
        if (string3 == null) {
            throw new BadConfigurationException("No value for " + string2);
        }
        ((Hashtable)System.getProperties()).put(string2, string3);
        try {
            parser = ParserFactory.makeParser();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage());
        }
        XmlHandler xmlHandler = new XmlHandler(webSite);
        parser.setDocumentHandler(xmlHandler);
        parser.setErrorHandler(xmlHandler);
        InputSource inputSource = new InputSource(new FileReader(string));
        try {
            parser.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new InvalidDataException(sAXException.getMessage());
        }
        return webSite;
    }

    private final void printUsage() {
        System.out.println("Usage   : java org.demo.webwader.XmlLoader [options] filename");
        System.out.println("Options : [-v|-d|-q][-V][-h]");
    }

    public boolean parseArg(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n++];
            int n3 = 1;
            while (n3 < string.length()) {
                char c = string.charAt(n3);
                switch (c) {
                    case 'V': {
                        VersionInfo.print();
                        break;
                    }
                    case 'q': {
                        ToolBox.verbose = false;
                        ToolBox.debug = false;
                        break;
                    }
                    case 'v': {
                        ToolBox.verbose = true;
                        ToolBox.debug = false;
                        break;
                    }
                    case 'd': {
                        ToolBox.verbose = true;
                        ToolBox.debug = true;
                        break;
                    }
                    default: {
                        ++n2;
                    }
                }
                ++n3;
            }
        }
        if (n < stringArray.length) {
            this.filename = stringArray[n];
        } else {
            this.printUsage();
            ++n2;
        }
        return n2 == 0;
    }
}

