/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader;

import org.ariane.tools.ToolBox;
import org.demo.webwader.InvalidDataException;
import org.demo.webwader.InvalidLocatorException;
import org.demo.webwader.Locator;
import org.demo.webwader.WebNode;
import org.demo.webwader.WebPage;
import org.demo.webwader.WebSite;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlHandler
extends HandlerBase {
    static final int UNDEF = -2;
    static final int WEBSITE = 0;
    static final int WEBPAGE = 1;
    static final int TITLE = 2;
    static final int URL = 3;
    private int mark;
    private WebSite site;
    private String dir_url = null;
    private WebNode node;

    public XmlHandler(WebSite webSite) {
        this.site = webSite;
        this.mark = -2;
        this.node = null;
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (string.equalsIgnoreCase("WebSite")) {
            this.mark = 0;
            this.site.setName(attributeList.getValue("name"));
        } else if (string.equalsIgnoreCase("WebPage")) {
            this.mark = 1;
            try {
                Locator locator = Locator.makeLocator(this.dir_url, attributeList.getValue("path"));
                WebPage webPage = new WebPage(locator);
                webPage.setName(attributeList.getValue("name"));
                WebNode webNode = new WebNode(webPage);
                if (this.site.getTopNode() == null) {
                    this.site.setTopNode(webNode);
                    this.node = webNode;
                    return;
                }
                this.node.add(webNode);
                this.node = webNode;
            }
            catch (InvalidLocatorException invalidLocatorException) {
                throw new SAXException(invalidLocatorException);
            }
        } else if (string.equalsIgnoreCase("URL")) {
            this.mark = 3;
        } else if (string.equalsIgnoreCase("Title")) {
            this.mark = 2;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        try {
            switch (this.mark) {
                case 2: {
                    this.node.setTitle(string);
                    break;
                }
                case 3: {
                    this.dir_url = string.trim();
                }
            }
        }
        catch (InvalidDataException invalidDataException) {
            if (ToolBox.debug) {
                String string2 = new String(cArray, n, n2);
                System.out.println("Invalid data : " + string2);
            }
            throw new SAXException(invalidDataException);
        }
    }

    public void endElement(String string) throws SAXException {
        if (string.equalsIgnoreCase("WebPage")) {
            this.node = (WebNode)this.node.getParent();
        }
    }

    public String toString() {
        return "XmlHandler";
    }

    public void fatalError(SAXParseException sAXParseException) {
        this.error(sAXParseException);
    }

    public void error(SAXParseException sAXParseException) {
        this.explain(sAXParseException);
        Exception exception = sAXParseException.getException();
        if (exception == null) {
            ToolBox.warn("XML parse   error", sAXParseException);
        } else {
            ToolBox.warn("XML parse   error", sAXParseException);
            ToolBox.warn("XML handler error", exception);
        }
    }

    public void warning(SAXParseException sAXParseException) {
        this.explain(sAXParseException);
        Exception exception = sAXParseException.getException();
        if (exception == null) {
            ToolBox.warn("XML handler warning", sAXParseException);
        } else {
            ToolBox.warn("XML handler warning", exception);
        }
    }

    private final void explain(SAXParseException sAXParseException) {
        ToolBox.warn("Parse error line : " + sAXParseException.getLineNumber() + " (column " + sAXParseException.getColumnNumber() + ")");
    }
}

