/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.ariane.tools.InputDataset;
import org.ariane.tools.LineTokenizer;
import org.ariane.tools.Nobject;
import org.ariane.tools.OutputDataset;
import org.ariane.tools.PlainList;
import org.ariane.tools.ToolBox;
import org.demo.webwader.InvalidDataException;
import org.demo.webwader.InvalidLocatorException;
import org.demo.webwader.Locator;
import org.demo.webwader.Resources;
import org.demo.webwader.WebNode;

public class WebSite
extends Nobject {
    private WebNode top = null;
    private String top_dir_url = null;
    public static final String SUFFIX = ".site";
    public static final String SP = " ";
    private static String indent = null;

    public WebSite() {
        this("WebSite");
    }

    public WebSite(String string) {
        super(string);
    }

    public final void setTopNode(WebNode webNode) {
        this.top = webNode;
    }

    public final WebNode getTopNode() {
        return this.top;
    }

    protected final String getTopDirURL() {
        if (this.top_dir_url != null) {
            return this.top_dir_url;
        }
        if (this.top == null) {
            return null;
        }
        Locator locator = this.top.getLocator();
        this.top_dir_url = locator.getSchemeServerSpec() + locator.getParentPath();
        return this.top_dir_url;
    }

    public final ListIterator getIterator(int n) {
        if (this.top == null) {
            return null;
        }
        PlainList plainList = new PlainList(this.getEnumeration(n));
        return plainList.listIterator();
    }

    private final Enumeration getEnumeration(int n) {
        switch (n) {
            case 1: {
                return this.top.preorderEnumeration();
            }
            case 2: {
                return this.top.postorderEnumeration();
            }
        }
        return this.top.breadthFirstEnumeration();
    }

    /*
     * Unable to fully structure code
     */
    public void read(String var1_1) throws IOException {
        if (var1_1 == null) {
            throw new IOException("Invalid null filename");
        }
        var3_2 = new InputDataset(var1_1);
        var4_3 = var3_2.createReader();
        var5_4 = var4_3.nextLine();
        var6_5 = var5_4.indexOf(":");
        if (var6_5 < 1) {
            throw new InvalidDataException("No separator found on line : " + var5_4);
        }
        if (!var5_4.substring(0, var6_5).trim().equalsIgnoreCase("Name")) {
            throw new InvalidDataException("No name tag found on line : " + var5_4);
        }
        this.setName(var5_4.substring(var6_5 + 1).trim());
        var5_4 = var4_3.nextLine();
        var6_5 = var5_4.indexOf(":");
        if (var6_5 < 1) {
            throw new InvalidDataException("No separator found on line : " + var5_4);
        }
        if (!var5_4.substring(0, var6_5).trim().equalsIgnoreCase("URL")) {
            throw new InvalidDataException("No url tag found on line : " + var5_4);
        }
        var7_6 = var5_4.substring(var6_5 + 1).trim();
        while ((var5_4 = var4_3.nextLine()) != null) {
            var8_7 = new LineTokenizer(var5_4);
            try {
                var9_8 = var8_7.nextToken().trim();
                if (this.top == null) {
                    this.top = var10_9 = new WebNode(Locator.makeLocator(var7_6, var9_8));
                } else {
                    var10_9 = this.top.findNode(var7_6 + var9_8);
                    if (var10_9 == null) {
                        if (ToolBox.debug) {
                            ToolBox.warn("Dir URL " + var7_6);
                            System.out.println(this.top.getVolume());
                        }
                        throw new InvalidDataException("Page without parent " + var9_8);
                    }
                }
                var8_7.nextToken(" ");
                var9_8 = var8_7.nextToken();
                this.addChild(var10_9, var7_6, var9_8);
                if (true) ** GOTO lbl44
            }
            catch (InvalidLocatorException var11_10) {
                throw new InvalidDataException("Invalid path on " + var5_4);
            }
            catch (NoSuchElementException var12_11) {
                throw new InvalidDataException("Invalid page on " + var5_4);
            }
            do {
                var9_8 = var8_7.nextToken();
                this.addChild(var10_9, var7_6, var9_8);
lbl44:
                // 2 sources

            } while (var8_7.hasMoreTokens());
        }
        var3_2.close();
    }

    private final void addChild(WebNode webNode, String string, String string2) throws InvalidDataException {
        string2.trim();
        WebNode webNode2 = this.top.findNode(string2);
        if (webNode2 != null) {
            throw new InvalidDataException("Page already defined " + string2);
        }
        try {
            webNode2 = new WebNode(Locator.makeLocator(string, string2));
        }
        catch (InvalidLocatorException invalidLocatorException) {
            if (ToolBox.debug) {
                ToolBox.warn("Url, path : " + string + ", " + string2);
            }
            throw new InvalidDataException("Invalid location " + string2);
        }
        webNode.add(webNode2);
    }

    public void write() throws IOException {
        File file = new File(ToolBox.markAsTemp(this.getName() + SUFFIX));
        this.write(file.getPath());
        file.deleteOnExit();
    }

    public void write(String string) throws IOException {
        if (string == null) {
            throw new IOException("Invalid null filename");
        }
        int n = 0;
        OutputDataset outputDataset = new OutputDataset(string);
        outputDataset.open();
        outputDataset.writeHeader("Description of Web Site : " + this.getName() + " - WebWader version " + "2.4.0");
        String string2 = this.getTopDirURL();
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        int n2 = string2.length();
        outputDataset.writeLine("Name : " + this.getName());
        outputDataset.writeLine("URL  : " + string2);
        outputDataset.writeNL();
        Enumeration enumeration = this.getEnumeration(n);
        while (enumeration.hasMoreElements()) {
            Object object;
            WebNode webNode = (WebNode)enumeration.nextElement();
            if (webNode.isLeaf()) continue;
            StringBuffer stringBuffer = null;
            try {
                object = webNode.getLocation();
                object = ((String)object).length() <= n2 ? "" : ((String)object).substring(n2);
                stringBuffer = new StringBuffer((String)object);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                ToolBox.warn("Node out " + webNode.getLocation());
                continue;
            }
            stringBuffer.append(" :");
            object = webNode.children();
            while (object.hasMoreElements()) {
                WebNode webNode2 = (WebNode)object.nextElement();
                try {
                    stringBuffer.append(' ').append(webNode2.getLocation().substring(n2));
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    ToolBox.warn("Child out " + webNode2.getLocation() + " index " + n2, stringIndexOutOfBoundsException);
                }
            }
            outputDataset.writeLine(stringBuffer.toString().trim());
        }
        outputDataset.writeNL();
        outputDataset.writeFooter();
        outputDataset.close();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("WebSite : ").append(this.getName());
        stringBuffer.append(" Server : ").append(this.top.getServerSpec());
        stringBuffer.append(" Number of leaves : " + this.top.getLeafCount());
        return stringBuffer.toString();
    }

    public void writeXML(String string) throws IOException {
        if (string == null) {
            throw new IOException("Invalid null filename");
        }
        if (this.top == null) {
            throw new InvalidDataException("Empty site");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        printWriter.println(ToolBox.XMLHeader("WebWader version = '2.4.0'"));
        printWriter.println(this.getDocType());
        printWriter.println("<WebSite name = '" + this.getName() + "' date = '" + new Date() + "'>");
        String string2 = this.getTopDirURL();
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        printWriter.println("<URL>" + string2 + "</URL>\n");
        if (indent == null) {
            int n = Resources.instance().get("WebWader.XML.Indentation", 0);
            if (n < 0) {
                n = 0;
            } else if (n > 8) {
                n = 8;
            }
            indent = "         ".substring(0, n);
        }
        this.writeXMLNode(this.top, string2.length(), printWriter, "");
        printWriter.println("</WebSite>");
        printWriter.close();
    }

    private void writeXMLNode(WebNode webNode, int n, PrintWriter printWriter, String string) {
        Object object;
        try {
            object = webNode.getLocation();
            object = ((String)object).length() <= n ? "" : ((String)object).substring(n);
            printWriter.println(string + "<WebPage name = '" + webNode.getName() + "' path = '" + (String)object + "'>");
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            ToolBox.warn("Node out " + webNode.getLocation());
        }
        printWriter.println(string + "<Title>" + webNode.getTitle() + "</Title>");
        object = webNode.children();
        while (object.hasMoreElements()) {
            WebNode webNode2 = (WebNode)object.nextElement();
            this.writeXMLNode(webNode2, n, printWriter, string + indent);
        }
        printWriter.println(string + "</WebPage>");
    }

    private final String getDocType() {
        String string = Resources.instance().getLibDirectory() + "xml/webwader.dtd";
        try {
            string = Locator.unescapeChar(Locator.makeLocator(string).getLocation());
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuffer stringBuffer = new StringBuffer("<!DOCTYPE ").append("WebSite");
        stringBuffer.append(" SYSTEM '").append(string).append("'>");
        return stringBuffer.toString();
    }
}

