/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader;

import java.net.MalformedURLException;
import java.net.URL;
import org.demo.webwader.InvalidLocatorException;
import org.demo.webwader.Locator;

public class WebPage {
    private Locator locator;
    private String title;
    private String name;

    public WebPage(Locator locator) {
        this.locator = locator;
        this.title = null;
        this.setName(locator);
    }

    public WebPage(String string) throws InvalidLocatorException {
        this(Locator.makeLocator(string));
    }

    public final String getLocation() {
        return this.locator.getLocation();
    }

    public final Locator getLocator() {
        return this.locator;
    }

    public final URL getURL() throws MalformedURLException {
        return this.locator.getURL();
    }

    public final String getPath() {
        return this.locator.getPath();
    }

    public final String getServerSpec() {
        return this.locator.getServerSpec();
    }

    public final String getTitle() {
        if (this.title == null) {
            return "Title of " + this.getPath();
        }
        return this.title;
    }

    public final void setTitle(String string) {
        if (string != null) {
            this.title = string;
        }
    }

    public String toString() {
        return this.getName();
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String string) {
        this.name = string;
    }

    private final void setName(Locator locator) {
        String string = locator.getFileName();
        if (string.startsWith("index.")) {
            string = locator.getParentName();
        }
        this.setName(string);
    }
}

