/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.demo.webwader.InvalidLocatorException;
import org.demo.webwader.Locator;
import org.demo.webwader.WebPage;

public class WebNode
extends DefaultMutableTreeNode {
    public static final int BREADTH_FIRST = 0;
    public static final int PREORDER = 1;
    public static final int POSTORDER = 2;
    public static final String[] ENUMERATION_MODE = new String[]{"BreadthFirst", "Preorder", "Postorder"};

    protected WebNode(Locator locator) {
        WebPage webPage = new WebPage(locator);
        this.setUserObject(webPage);
    }

    protected WebNode(String string) throws InvalidLocatorException {
        WebPage webPage = new WebPage(string);
        this.setUserObject(webPage);
    }

    protected WebNode(WebPage webPage) {
        this.setUserObject(webPage);
    }

    protected WebNode() {
    }

    public String getPagePath() {
        return ((WebPage)this.getUserObject()).getPath();
    }

    public final int getDirDepth() {
        return this.getLocator().getDirDepth();
    }

    private final int getLinkDepth() {
        return this.getPath().length;
    }

    public final Locator getLocator() {
        return ((WebPage)this.getUserObject()).getLocator();
    }

    public final URL getURL() throws MalformedURLException {
        return ((WebPage)this.getUserObject()).getURL();
    }

    public final String getLocation() {
        return ((WebPage)this.getUserObject()).getLocation();
    }

    public final String getServerSpec() {
        return ((WebPage)this.getUserObject()).getServerSpec();
    }

    public String getName() {
        return ((WebPage)this.getUserObject()).getName();
    }

    public String getTitle() {
        return ((WebPage)this.getUserObject()).getTitle();
    }

    public void setTitle(String string) {
        ((WebPage)this.getUserObject()).setTitle(string);
    }

    public static final int navigationOrder(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equalsIgnoreCase("Preorder")) {
            return 1;
        }
        if (string.equalsIgnoreCase("Postorder")) {
            return 2;
        }
        return 0;
    }

    public static final String navigationOrder(int n) {
        switch (n) {
            case 1: {
                return "PreOrder";
            }
            case 2: {
                return "PostOrder";
            }
            case 0: {
                return "Breadth_First";
            }
        }
        return "Unknown";
    }

    protected final WebNode findNode(String string) {
        if (string == null) {
            return null;
        }
        Enumeration<TreeNode> enumeration = this.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            WebNode webNode = (WebNode)enumeration.nextElement();
            String string2 = webNode.getLocation();
            if (!string.equals(string2)) continue;
            return webNode;
        }
        return null;
    }

    public final String getVolume() {
        Serializable serializable;
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        Serializable serializable2 = null;
        Serializable serializable3 = null;
        Serializable serializable4 = null;
        Serializable serializable5 = null;
        Enumeration<TreeNode> enumeration = this.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            serializable = (WebNode)enumeration.nextElement();
            int n5 = ((WebNode)serializable).getDirDepth();
            if (n5 > n2) {
                n2 = n5;
                serializable3 = serializable;
            }
            if (n5 < n) {
                n = n5;
                serializable2 = serializable;
            }
            if ((n5 = super.getLinkDepth()) > n4) {
                n4 = n5;
                serializable5 = serializable;
            }
            if (n5 >= n3) continue;
            n3 = n5;
            serializable4 = serializable;
        }
        serializable = new StringBuffer("\n");
        ((StringBuffer)serializable).append("Dir  min : ").append(serializable2.getLocator());
        ((StringBuffer)serializable).append(" (depth : ").append(n).append(")\n");
        ((StringBuffer)serializable).append("Dir  max : ").append(((WebNode)serializable3).getLocator());
        ((StringBuffer)serializable).append(" (depth : ").append(n2).append(")\n");
        ((StringBuffer)serializable).append("Link min : ").append(((WebNode)serializable4).getLocator());
        ((StringBuffer)serializable).append(" (depth : ").append(n3).append(")\n");
        ((StringBuffer)serializable).append("Link max : ").append(((WebNode)serializable5).getLocator());
        ((StringBuffer)serializable).append(" (depth : ").append(n4).append(")\n");
        return ((StringBuffer)serializable).toString();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof WebNode)) {
            return false;
        }
        return this.getLocation().equals(((WebNode)object).getLocation());
    }

    public final void dumpBreadthFirst() {
        Enumeration<TreeNode> enumeration = this.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            System.out.print(((WebNode)enumeration.nextElement()).toString() + ' ');
        }
        System.out.println();
    }

    public final void dumpPostorder() {
        Enumeration<TreeNode> enumeration = this.postorderEnumeration();
        while (enumeration.hasMoreElements()) {
            System.out.print(((WebNode)enumeration.nextElement()).toString() + ' ');
        }
        System.out.println();
    }

    public final void dumpPreorder() {
        Enumeration<TreeNode> enumeration = this.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            System.out.print(((WebNode)enumeration.nextElement()).toString() + ' ');
        }
        System.out.println();
    }

    public String toString() {
        return this.getUserObject().toString();
    }
}

