/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader;

import java.io.PrintWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.ElementIterator;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import org.ariane.tools.LineTokenizer;
import org.ariane.tools.MiniSet;
import org.ariane.tools.Nobject;
import org.ariane.tools.ToolBox;
import org.demo.webwader.InvalidLocatorException;
import org.demo.webwader.Locator;
import org.demo.webwader.Resources;
import org.demo.webwader.TooManyNodesException;
import org.demo.webwader.WebNode;

public class SiteScanner
extends Nobject {
    private static SiteScanner scanner = null;
    private WebNode top = null;
    private String top_dir_url = null;
    private int node_nbr = 0;
    private int max_node_nbr;
    private int max_dir_depth;
    private Collection ignored;
    private Collection frames;
    private boolean give_up = false;
    private int scan_order = 0;
    private MiniSet scan_path = null;
    private PrintWriter printer = new PrintWriter(System.out);

    public static SiteScanner instance() {
        if (scanner == null) {
            scanner = new SiteScanner();
        }
        return scanner;
    }

    private SiteScanner() {
        super("SiteScanner");
        this.max_node_nbr = Resources.instance().get("WebWader.MaxNodeNbr", 200);
        this.max_dir_depth = Resources.instance().get("WebWader.MaxDirDepth", 10);
    }

    public final void setPrinter(PrintWriter printWriter) {
        this.printer = printWriter;
    }

    public WebNode scan(String string, String string2, int n) throws InvalidLocatorException {
        long l = System.currentTimeMillis();
        this.node_nbr = 1;
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        this.give_up = false;
        this.scan_order = n;
        this.top_dir_url = null;
        this.loadIgnoredList();
        this.loadIgnoredList(Resources.instance().get("WebWader." + string + ".Ignored"));
        if (ToolBox.debug) {
            ToolBox.warn("Ignored : " + scanner.getIgnoredList());
        }
        HttpURLConnection.setFollowRedirects(false);
        Locator locator = Locator.makeLocator(string2);
        String string3 = locator.getRedirectedLocation();
        if (string3 != null) {
            locator = Locator.makeLocator(string3);
        }
        if (!locator.isReadable()) {
            throw new InvalidLocatorException("Not readable " + locator);
        }
        this.top = new WebNode(locator);
        this.frames = new ArrayList();
        if (this.scan_order == 2) {
            this.scan_path = new MiniSet(this.max_node_nbr);
        }
        this.scanPage(hTMLEditorKit, this.top);
        if (this.frames.size() > 0) {
            this.mergeFrames();
        }
        long l2 = (System.currentTimeMillis() - l) / 1000L;
        if (ToolBox.verbose) {
            this.printer.println();
            this.printer.println("Found " + this.node_nbr + " nodes.");
            this.printer.println("Scan done in " + l2 + " s.");
        }
        if (ToolBox.debug) {
            this.printer.println(this.top.getVolume());
        }
        this.printer.flush();
        return this.top;
    }

    private void scanPage(EditorKit editorKit, WebNode webNode) throws InvalidLocatorException {
        Object object;
        Object object2;
        if (this.giveUp()) {
            return;
        }
        Locator locator = webNode.getLocator();
        this.printer.println();
        this.printer.flush();
        this.printer.println("Scanning " + locator);
        int n = locator.getContentType();
        if (n == 0) {
            if (ToolBox.debug) {
                this.printer.print("\tNot HTML : " + locator);
            }
            return;
        }
        if (locator.getDirDepth() > this.max_dir_depth) {
            throw new InvalidLocatorException("Too deep location " + this.max_dir_depth);
        }
        Document document = editorKit.createDefaultDocument();
        document.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        try {
            object2 = locator.getReader();
            editorKit.read((Reader)object2, document, 0);
            webNode.setTitle((String)document.getProperty("title"));
        }
        catch (Exception exception) {
            if (ToolBox.verbose) {
                ToolBox.warn("Can't read " + locator);
            }
            return;
        }
        ElementIterator elementIterator = new ElementIterator(document);
        String string = HTML.Tag.FRAME.toString();
        block8: while ((object2 = elementIterator.next()) != null) {
            object = object2.getAttributes();
            if (object == null) continue;
            String string2 = null;
            if (object2.getName().equals(string)) {
                string2 = (String)object.getAttribute(HTML.Attribute.SRC);
            } else {
                if ((object = (AttributeSet)object.getAttribute(HTML.Tag.A)) == null) continue;
                string2 = (String)object.getAttribute(HTML.Attribute.HREF);
            }
            if (string2 != null) {
                string2 = string2.trim();
            }
            if (!Locator.isAcceptable(string2)) continue;
            try {
                Locator locator2 = Locator.makeLocator(locator, string2);
                if (ToolBox.debug) {
                    this.printer.print("\tLink " + string2);
                }
                if (!this.isServed(locator2)) {
                    if (!ToolBox.debug) continue;
                    this.printer.println(" outside");
                    continue;
                }
                String string3 = locator2.getRedirectedLocation();
                if (string3 != null) {
                    locator2 = Locator.makeLocator(string3);
                    if (ToolBox.verbose) {
                        this.printer.println(" redirected : " + locator2.toString());
                    }
                }
                if (this.isIgnored(string2 = locator2.getLocation())) {
                    if (!ToolBox.verbose) continue;
                    this.printer.println(" ignored : " + locator2.toString());
                    continue;
                }
                if (!locator2.isBelow(this.getTopDirURL())) {
                    if (!ToolBox.verbose) continue;
                    this.printer.println(" not below : " + locator2.toString());
                    continue;
                }
                int n2 = locator2.getReadCode();
                if (200 <= n2 && n2 < 300) {
                    if (ToolBox.debug) {
                        this.printer.println(" new : " + locator2.toString());
                    }
                } else {
                    if (!ToolBox.verbose) continue;
                    this.printer.println(" unreadable : " + locator2.toString() + " code : " + n2);
                    continue;
                }
                WebNode webNode2 = this.top.findNode(string2);
                if (webNode2 != null) {
                    if (!ToolBox.debug) continue;
                    this.printer.println(" known : " + locator2.toString());
                    continue;
                }
                if (this.node_nbr > this.max_node_nbr) {
                    throw new TooManyNodesException("Too many nodes " + this.node_nbr);
                }
                webNode2 = new WebNode(locator2);
                if (object2.getName().equals(string)) {
                    this.frames.add(webNode2);
                }
                switch (this.scan_order) {
                    case 1: {
                        webNode.add(webNode2);
                        ++this.node_nbr;
                        this.printer.println("\tAdded " + locator2.toString());
                        this.scanPage(editorKit, webNode2);
                        break;
                    }
                    case 2: {
                        int n3 = this.scan_path.indexOf(webNode2);
                        if (n3 >= 0 || webNode.findNode(string2) != null) continue block8;
                        this.scan_path.add(webNode2);
                        this.scanPage(editorKit, webNode2);
                        webNode.add(webNode2);
                        ++this.node_nbr;
                        this.printer.println("\tAdded : " + locator2.toString());
                        break;
                    }
                    default: {
                        webNode.add(webNode2);
                        ++this.node_nbr;
                        this.printer.println("\tAdded : " + locator2.toString());
                        break;
                    }
                }
            }
            catch (InvalidLocatorException invalidLocatorException) {
                ToolBox.warn("Can't make locator : " + string2, invalidLocatorException);
            }
        }
        if (this.scan_order == 0) {
            object = webNode.children();
            while (object.hasMoreElements()) {
                this.scanPage(editorKit, (WebNode)object.nextElement());
            }
        }
    }

    private final synchronized void mergeFrames() {
        Iterator iterator = this.frames.iterator();
        while (iterator.hasNext()) {
            WebNode webNode = (WebNode)iterator.next();
            WebNode webNode2 = (WebNode)webNode.getParent();
            int n = webNode2.getChildCount();
            int n2 = webNode.getChildCount();
            int n3 = 0;
            while (n3 < n2) {
                WebNode webNode3 = (WebNode)webNode.getFirstChild();
                webNode2.insert(webNode3, n++);
                ++n3;
            }
            webNode2.remove(webNode);
        }
    }

    private final synchronized boolean giveUp() {
        return this.give_up;
    }

    public final synchronized void giveUpScan() {
        this.give_up = true;
    }

    public final boolean isIgnored(String string) {
        Iterator iterator = this.ignored.iterator();
        while (iterator.hasNext()) {
            if (string.indexOf((String)iterator.next()) < 0) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SiteScanner : ").append(this.getName());
        stringBuffer.append(" Server : ").append(this.top.getServerSpec());
        stringBuffer.append(" Number of pages : " + this.node_nbr);
        return stringBuffer.toString();
    }

    protected final String getIgnoredList() {
        return this.ignored == null ? null : this.ignored.toString();
    }

    private final void loadIgnoredList() {
        this.loadIgnoredList(null);
        String string = "?N=D ?M=A ?S=A ?D=A";
        this.loadIgnoredList(string);
        string = Resources.instance().get("WebWader.Ignored");
        this.loadIgnoredList(string);
    }

    private final void loadIgnoredList(String string) {
        if (string == null || string.length() < 1) {
            if (this.ignored == null) {
                this.ignored = new MiniSet();
            }
            return;
        }
        LineTokenizer lineTokenizer = new LineTokenizer(string);
        if (this.ignored == null) {
            this.ignored = new MiniSet(lineTokenizer.countTokens());
        }
        int n = 0;
        while (lineTokenizer.hasMoreTokens()) {
            this.ignored.add(((StringTokenizer)lineTokenizer).nextToken());
            ++n;
        }
    }

    private final boolean isServed(Locator locator) {
        if (this.top == null) {
            return false;
        }
        String string = this.top.getServerSpec();
        return string.equals(locator.getServerSpec());
    }

    private final String getTopDirURL() {
        if (this.top_dir_url != null) {
            return this.top_dir_url;
        }
        Locator locator = this.top.getLocator();
        this.top_dir_url = locator.getSchemeServerSpec() + locator.getParentPath();
        return this.top_dir_url;
    }
}

