/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.UnknownHostException;
import org.ariane.tools.ToolBox;
import org.ariane.tools.TryProg;
import org.demo.webwader.VersionInfo;

class SendURL
extends TryProg {
    private int port = 8333;

    public static void main(String[] stringArray) {
        SendURL sendURL = new SendURL("SendURL");
        if (!sendURL.parseArg(stringArray)) {
            ToolBox.warn("Can't parse command line");
            return;
        }
        if (!sendURL.run()) {
            ToolBox.warn("Can't run " + sendURL.getName());
            System.exit(0);
        }
    }

    public SendURL(String string) {
        super(string);
    }

    public boolean run() {
        if (ToolBox.verbose) {
            ToolBox.warn("Connecting to port " + this.port);
        }
        ToolBox.warn("Enter 'quit' to stop");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            while (true) {
                System.out.print("URL : ");
                String string = bufferedReader.readLine();
                if (string == null || string.equalsIgnoreCase("quit")) {
                    return true;
                }
                this.sendURL(string);
            }
        }
        catch (Exception exception) {
            ToolBox.warn("Can't communicate with the server", exception);
            if (ToolBox.debug) {
                exception.printStackTrace();
            }
            return false;
        }
    }

    private final void sendURL(String string) throws UnknownHostException, IOException {
        if (ToolBox.debug) {
            System.out.println(string);
        }
        Socket socket = new Socket("localhost", this.port);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
        bufferedOutputStream.write(string.getBytes(), 0, string.length());
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
    }

    private final void printUsage() {
        System.out.println("Usage   : java org.demo.webwader.SendURL [options]");
        System.out.println("Options : [-v|-d|-q][-V][-h][-p port]");
    }

    public boolean parseArg(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n++];
            int n3 = 1;
            while (n3 < string.length()) {
                char c = string.charAt(n3);
                switch (c) {
                    case 'V': {
                        VersionInfo.print();
                        break;
                    }
                    case 'q': {
                        ToolBox.verbose = false;
                        ToolBox.debug = false;
                        break;
                    }
                    case 'v': {
                        ToolBox.verbose = true;
                        ToolBox.debug = false;
                        break;
                    }
                    case 'd': {
                        ToolBox.verbose = true;
                        ToolBox.debug = true;
                        break;
                    }
                    case 'p': {
                        this.port = Integer.parseInt(stringArray[n++]);
                        break;
                    }
                    default: {
                        this.printUsage();
                        ++n2;
                    }
                }
                ++n3;
            }
        }
        return n2 == 0;
    }
}

