/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader;

import org.ariane.time.Time;
import org.ariane.tools.ToolBox;
import org.ariane.tools.TryProg;
import org.demo.webwader.Resources;
import org.demo.webwader.SiteScanner;
import org.demo.webwader.VersionInfo;
import org.demo.webwader.WebNode;
import org.demo.webwader.WebSite;

class ScanSite
extends TryProg {
    private String url;
    private String sitename = "scanned";
    private String filename = null;
    private int scan_order = 0;

    public static void main(String[] stringArray) {
        ToolBox.debug = true;
        ToolBox.verbose = true;
        ScanSite scanSite = new ScanSite("ScanSite");
        if (!scanSite.parseArg(stringArray)) {
            ToolBox.warn("Can't parse command line");
            return;
        }
        if (!scanSite.run()) {
            ToolBox.warn("Can't run " + scanSite.getName());
            System.exit(1);
        }
        System.exit(0);
    }

    public ScanSite(String string) {
        super(string);
    }

    protected void setResources() {
        this.resources = Resources.instance();
    }

    public boolean run() {
        WebSite webSite = new WebSite(this.sitename);
        try {
            SiteScanner siteScanner = SiteScanner.instance();
            ToolBox.warn("Scanning " + this.url + " in " + WebNode.navigationOrder(this.scan_order) + " " + new Time());
            WebNode webNode = siteScanner.scan(this.sitename, this.url, this.scan_order);
            webSite.setTopNode(webNode);
            if (this.filename == null) {
                this.filename = this.sitename + ".site";
            }
            webSite.write(this.filename);
            if (this.resources.get("WebWader.XML.Save", ToolBox.hasXML())) {
                String string = this.sitename + ".xml";
                webSite.writeXML(string);
            }
            System.out.println("Done !");
        }
        catch (Exception exception) {
            try {
                webSite.write(this.filename);
            }
            catch (Exception exception2) {
                ToolBox.warn("Can't even write file ", exception2);
            }
            exception.printStackTrace();
            ToolBox.warn("Can't scan " + this.url, exception);
            return false;
        }
        return true;
    }

    private final void printUsage() {
        System.out.println("Usage   : java org.demo.webwader.ScanSite [options] url");
        System.out.println("Options : [-v|-d|-q][-V][-h][-s sitename][-o filename][-p|-P|-b]");
    }

    public boolean parseArg(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n++];
            int n3 = 1;
            while (n3 < string.length()) {
                char c = string.charAt(n3);
                switch (c) {
                    case 'V': {
                        VersionInfo.print();
                        break;
                    }
                    case 'q': {
                        ToolBox.verbose = false;
                        ToolBox.debug = false;
                        break;
                    }
                    case 'v': {
                        ToolBox.verbose = true;
                        ToolBox.debug = false;
                        break;
                    }
                    case 'd': {
                        ToolBox.verbose = true;
                        ToolBox.debug = true;
                        break;
                    }
                    case 's': {
                        this.sitename = stringArray[n++];
                        break;
                    }
                    case 'o': {
                        this.filename = stringArray[n++];
                        break;
                    }
                    case 'p': {
                        this.scan_order = 1;
                        break;
                    }
                    case 'P': {
                        this.scan_order = 2;
                        break;
                    }
                    case 'b': {
                        this.scan_order = 0;
                        break;
                    }
                    default: {
                        this.printUsage();
                        ++n2;
                    }
                }
                ++n3;
            }
        }
        if (n < stringArray.length) {
            this.url = stringArray[n];
        } else {
            ++n2;
        }
        return n2 == 0;
    }
}

