/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.demo.webwader.InvalidLocatorException;
import org.demo.webwader.Locator;

public class PathLocator
extends Locator {
    private static final String FILEL = "file:";
    private static final String FILEP = File.separatorChar == '\\' ? "file:/" : "file:";
    private File file;

    protected PathLocator(String string) throws InvalidLocatorException {
        if (string.startsWith(FILEL)) {
            string = string.substring(FILEL.length());
        }
        if (File.separatorChar == '\\') {
            string = string.replace('|', ':');
        }
        if (string.indexOf(32) >= 0) {
            string = Locator.escapeSpace(string);
        }
        try {
            this.file = new File(Locator.removeTag(string)).getCanonicalFile();
            this.setLocation(this.file.toURL());
        }
        catch (IOException iOException) {
            throw new InvalidLocatorException(iOException.getMessage());
        }
    }

    protected PathLocator(String string, String string2) throws InvalidLocatorException {
        if (string.startsWith(FILEL)) {
            string = string.substring(FILEL.length());
        }
        if (File.separatorChar == '\\') {
            string2 = string2.replace('|', ':');
            string = string.replace('|', ':');
        }
        if (string2.indexOf(32) >= 0) {
            string2 = Locator.escapeSpace(string2);
        }
        if (string.indexOf(32) >= 0) {
            string = Locator.escapeSpace(string);
        }
        if (!string.endsWith("/") && !string.endsWith("\\")) {
            string = new File(Locator.removeTag(string)).getParent();
        }
        try {
            this.file = new File(string, Locator.removeTag(string2)).getCanonicalFile();
            this.setLocation(this.file.toURL());
        }
        catch (IOException iOException) {
            throw new InvalidLocatorException(iOException.getMessage());
        }
    }

    private static final String addScheme(String string) {
        return string.startsWith(FILEL) ? string : FILEL + string;
    }

    protected final File getFilePath() {
        return this.file;
    }

    private final File getDecodedFilePath() {
        String string = this.file.getPath();
        if (string.indexOf(37) < 0) {
            return this.file;
        }
        return new File(Locator.unescapeChar(string));
    }

    protected final String getServerSpec() {
        return "";
    }

    protected final String getSchemeServerSpec() {
        return FILEP;
    }

    protected final String getRedirectedLocation() {
        return null;
    }

    protected final int getReadCode() {
        try {
            return this.isReadable() ? 200 : 404;
        }
        catch (Exception exception) {
            return 401;
        }
    }

    protected final boolean isReadable() {
        try {
            return this.getDecodedFilePath().canRead();
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected final boolean exists() {
        return this.getDecodedFilePath().exists();
    }

    protected final int getContentType() {
        return -1;
    }

    protected Reader getReader() throws IOException {
        FileInputStream fileInputStream = new FileInputStream(this.getDecodedFilePath().getPath());
        return new InputStreamReader(fileInputStream);
    }
}

