/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader;

import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import org.ariane.tools.ToolBox;
import org.ariane.tools.TryProg;
import org.demo.webwader.InvalidLocatorException;
import org.demo.webwader.Locator;
import org.demo.webwader.VersionInfo;

class PageParser
extends TryProg {
    private String location;

    public static void main(String[] stringArray) {
        PageParser pageParser = new PageParser("PageParser");
        if (!pageParser.parseArg(stringArray)) {
            ToolBox.warn("Can't parse command line");
            return;
        }
        if (!pageParser.run()) {
            ToolBox.warn("Can't run " + pageParser.getName());
            System.exit(0);
        }
    }

    public PageParser(String string) {
        super(string);
    }

    public boolean run() {
        try {
            Element element;
            int n;
            Locator locator;
            String string;
            if (ToolBox.verbose) {
                ToolBox.warn("Reading from " + this.location);
            }
            if ((string = (locator = Locator.makeLocator(this.location)).getRedirectedLocation()) != null) {
                locator = Locator.makeLocator(string);
                if (ToolBox.verbose) {
                    System.out.println(" redirected : " + locator.toString());
                }
            }
            if ((n = locator.getContentType()) == 0) {
                System.out.println("Location does not point to a HTML document.");
                return false;
            }
            HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
            Document document = ((EditorKit)hTMLEditorKit).createDefaultDocument();
            Reader reader = locator.getReader();
            document.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
            String string2 = HTML.Tag.FRAMESET.toString();
            String string3 = HTML.Tag.FRAME.toString();
            ((EditorKit)hTMLEditorKit).read(reader, document, 0);
            System.out.println("Type  : " + n);
            System.out.println("Title : " + (String)document.getProperty("title"));
            ElementIterator elementIterator = new ElementIterator(document);
            int n2 = 0;
            while ((element = elementIterator.next()) != null) {
                AttributeSet attributeSet;
                Enumeration<?> enumeration;
                AttributeSet attributeSet2;
                if (ToolBox.debug) {
                    System.out.println("Element " + n2++ + " " + element.getName());
                }
                if ((attributeSet2 = element.getAttributes()) == null) {
                    System.out.println("No attributes !");
                    continue;
                }
                if (ToolBox.debug) {
                    enumeration = attributeSet2.getAttributeNames();
                    while (enumeration.hasMoreElements()) {
                        System.out.println("\tAttr " + enumeration.nextElement());
                    }
                }
                if (element.getName().equals(string2)) {
                    System.out.println("Frameset");
                    enumeration = attributeSet2.getAttributeNames();
                    while (enumeration.hasMoreElements()) {
                        System.out.println("\tAttr " + enumeration.nextElement());
                    }
                }
                if (element.getName().equals(string3)) {
                    System.out.println("Frame");
                    enumeration = attributeSet2.getAttributeNames();
                    while (enumeration.hasMoreElements()) {
                        System.out.println("\tAttr " + enumeration.nextElement());
                    }
                    System.out.println("\tSrc " + attributeSet2.getAttribute(HTML.Attribute.SRC));
                }
                if ((attributeSet = (AttributeSet)attributeSet2.getAttribute(HTML.Tag.A)) == null) continue;
                System.out.println("A");
                enumeration = attributeSet.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    System.out.println("\tAttr " + enumeration.nextElement());
                    System.out.println("\tSrc " + attributeSet.getAttribute(HTML.Attribute.HREF));
                }
            }
            System.out.println("Done ! ");
            System.exit(0);
        }
        catch (InvalidLocatorException invalidLocatorException) {
            ToolBox.warn("Can't locate document", invalidLocatorException);
            return false;
        }
        catch (IOException iOException) {
            if (ToolBox.debug) {
                iOException.printStackTrace();
            }
            ToolBox.warn("Can't read document", iOException);
            return false;
        }
        catch (Exception exception) {
            if (ToolBox.debug) {
                exception.printStackTrace();
            }
            ToolBox.warn("Can't parse document", exception);
            return false;
        }
        return true;
    }

    private final void printUsage() {
        System.out.println("Usage   : java org.demo.webwader.PageParser [options] location");
        System.out.println("Options : [-v|-d|-q][-V][-h]");
    }

    public boolean parseArg(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n++];
            int n3 = 1;
            while (n3 < string.length()) {
                char c = string.charAt(n3);
                switch (c) {
                    case 'V': {
                        VersionInfo.print();
                        break;
                    }
                    case 'q': {
                        ToolBox.verbose = false;
                        ToolBox.debug = false;
                        break;
                    }
                    case 'v': {
                        ToolBox.verbose = true;
                        ToolBox.debug = false;
                        break;
                    }
                    case 'd': {
                        ToolBox.verbose = true;
                        ToolBox.debug = true;
                        break;
                    }
                    default: {
                        this.printUsage();
                        ++n2;
                    }
                }
                ++n3;
            }
        }
        if (n < stringArray.length) {
            this.location = stringArray[n];
        }
        return n2 == 0;
    }
}

