/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.demo.webwader.InvalidLocatorException;
import org.demo.webwader.Locator;

public class NetLocator
extends Locator {
    protected NetLocator(String string) throws InvalidLocatorException {
        super(string);
    }

    protected NetLocator(String string, String string2) throws InvalidLocatorException {
        super(string, string2);
    }

    protected final String getServerSpec() {
        int n;
        URL uRL = this.getURL();
        StringBuffer stringBuffer = new StringBuffer();
        String string = uRL.getProtocol();
        if (string.length() > 0) {
            stringBuffer.append(string).append(":");
        }
        if ((string = uRL.getHost()).length() > 0) {
            stringBuffer.append("//").append(string);
        }
        if ((n = uRL.getPort()) > 0) {
            stringBuffer.append(":").append(n);
        }
        return stringBuffer.toString();
    }

    protected final String getSchemeServerSpec() {
        return this.getServerSpec();
    }

    protected final boolean isReadable() {
        int n = this.getReadCode();
        return 200 <= n && n < 300;
    }

    protected final boolean exists() {
        int n = this.getReadCode();
        return n == 200;
    }

    protected final int getContentType() {
        try {
            URL uRL = this.getURL();
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("HEAD");
            String string = httpURLConnection.getContentType();
            if (string == null) {
                return -1;
            }
            return string.toLowerCase().startsWith("text/html") ? 1 : 0;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    protected final String getRedirectedLocation() {
        try {
            URL uRL = this.getURL();
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("HEAD");
            int n = httpURLConnection.getResponseCode();
            return 300 <= n && n < 400 ? httpURLConnection.getHeaderField("Location") : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected final int getReadCode() {
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.getURL().openConnection();
            httpURLConnection.setRequestMethod("HEAD");
            return httpURLConnection.getResponseCode();
        }
        catch (Exception exception) {
            return 400;
        }
    }

    protected Reader getReader() throws IOException {
        InputStream inputStream = this.getURL().openStream();
        return new InputStreamReader(inputStream);
    }
}

