/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import org.ariane.tools.ToolBox;
import org.demo.webwader.InvalidLocatorException;
import org.demo.webwader.NetLocator;
import org.demo.webwader.PathLocator;

public abstract class Locator {
    private URL location;
    protected static final int TYPE_UNKNOWN = -1;
    protected static final int TYPE_HTML = 1;
    protected static final int TYPE_PLAIN_TEXT = 2;
    protected static final int TYPE_NOT_HTML = 0;

    public static Locator makeLocator(String string) throws InvalidLocatorException {
        if (Locator.isLocalPath(string)) {
            return new PathLocator(string);
        }
        return new NetLocator(string);
    }

    public static Locator makeLocator(String string, String string2) throws InvalidLocatorException {
        if (Locator.isLocalPath(string) && Locator.isLocalPath(string2)) {
            return new PathLocator(string, string2);
        }
        return new NetLocator(string, string2);
    }

    public static Locator makeLocator(Locator locator, String string) throws InvalidLocatorException {
        return Locator.makeLocator(locator.getLocation(), string);
    }

    private static boolean isLocalPath(String string) {
        int n = string.indexOf(58);
        if (n < 0 || string.substring(0, n).equals("file")) {
            return true;
        }
        if (n == 1 && File.separatorChar != '/') {
            return Character.isLetter(string.charAt(0));
        }
        return false;
    }

    protected Locator() {
        this.location = null;
    }

    protected Locator(String string) throws InvalidLocatorException {
        this.setLocation(string);
    }

    protected Locator(String string, String string2) throws InvalidLocatorException {
        this.setLocation(string, string2);
    }

    protected final void setLocation(String string) throws InvalidLocatorException {
        try {
            if (string.indexOf(32) >= 0) {
                string = Locator.escapeSpace(string);
            }
            this.location = new URL(Locator.removeTag(string));
        }
        catch (MalformedURLException malformedURLException) {
            throw new InvalidLocatorException(malformedURLException.getMessage());
        }
    }

    protected final void setLocation(URL uRL) {
        this.location = uRL;
    }

    protected final void setLocation(String string, String string2) throws InvalidLocatorException {
        try {
            if (string2.indexOf(32) >= 0) {
                string2 = Locator.escapeSpace(string2);
            }
            this.location = new URL(new URL(string), Locator.removeTag(string2));
        }
        catch (MalformedURLException malformedURLException) {
            throw new InvalidLocatorException(malformedURLException.getMessage());
        }
    }

    protected static final String removeTag(String string) {
        int n = string.indexOf(35);
        return n < 0 ? string : string.substring(0, n);
    }

    protected static final String escapeSpace(String string) {
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        byte[] byArray2 = new byte[3 * n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (byArray[n3] == 32) {
                byArray2[n2++] = 37;
                byArray2[n2++] = 50;
                byArray2[n2++] = 48;
            } else {
                byArray2[n2++] = byArray[n3];
            }
            ++n3;
        }
        return new String(byArray2, 0, n2);
    }

    protected static final String unescapeChar(String string) {
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (byArray[n3] == 37) {
                try {
                    byArray3[0] = byArray[n3 + 1];
                    byArray3[1] = byArray[n3 + 2];
                    byArray2[n2++] = Byte.parseByte(new String(byArray3), 16);
                    n3 += 2;
                }
                catch (NumberFormatException numberFormatException) {
                    byArray2[n2++] = byArray[n3];
                }
            } else {
                byArray2[n2++] = byArray[n3];
            }
            ++n3;
        }
        return new String(byArray2, 0, n2);
    }

    protected final String getLocation() {
        return this.location.toExternalForm();
    }

    protected final URL getURL() {
        return this.location;
    }

    protected final String getFileName() {
        return this.isRoot() ? "/" : this.getFilePath().getName();
    }

    protected final String getParentPath() {
        if (this.isRoot()) {
            return "/";
        }
        String string = this.getFilePath().getParent();
        if (string == null) {
            return ".";
        }
        if (File.separatorChar == '/') {
            return string;
        }
        return string.replace(File.separatorChar, '/');
    }

    protected final String getParentName() {
        if (this.isRoot()) {
            return "/";
        }
        File file = this.getFilePath().getParentFile();
        if (file == null) {
            return ".";
        }
        String string = file.getName();
        return string.equals("") ? "/" : string;
    }

    protected File getFilePath() {
        return new File(this.getPath());
    }

    protected final String getPath() {
        return this.isRoot() ? "/" : this.location.getFile();
    }

    private final boolean isRoot() {
        String string = this.location.getFile();
        return string.equals("/") || string.equals("");
    }

    protected abstract String getServerSpec();

    protected abstract String getSchemeServerSpec();

    protected abstract String getRedirectedLocation();

    protected final int getDirDepth() {
        return new StringTokenizer(this.getPath(), "/").countTokens();
    }

    protected final boolean isBelow(String string) {
        String string2 = this.getLocation();
        return string2.startsWith(string) && string2.length() > string.length();
    }

    protected static final boolean isAcceptable(String string) {
        if (string == null) {
            return false;
        }
        if (string.startsWith("mailto:")) {
            return false;
        }
        if (string.startsWith("javascript:")) {
            return false;
        }
        if (string.startsWith("ftp:")) {
            return false;
        }
        if (string.startsWith("news:")) {
            return false;
        }
        return !string.startsWith("#");
    }

    public final String toString() {
        return this.location.toString();
    }

    public final String paramString() {
        StringBuffer stringBuffer = new StringBuffer("Location : ").append(this.getLocation());
        stringBuffer.append(" Server : ").append(this.getServerSpec());
        stringBuffer.append(" Path : ").append(this.getPath());
        stringBuffer.append(" FilePath : ").append(this.getFilePath().getPath());
        stringBuffer.append(" DirPath : ").append(this.getParentPath());
        stringBuffer.append(" DirName : ").append(this.getParentName());
        stringBuffer.append(" Name : ").append(this.getFileName());
        stringBuffer.append(" Exists : ").append(this.exists() ? "yes" : "no");
        stringBuffer.append(" Readable : ").append(this.isReadable() ? "yes" : "no");
        return stringBuffer.toString();
    }

    protected abstract int getReadCode();

    protected abstract boolean isReadable();

    protected abstract boolean exists();

    protected abstract int getContentType();

    protected abstract Reader getReader() throws IOException;

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            Locator.printUsage();
            return;
        }
        try {
            Locator locator = Locator.makeLocator(stringArray[0]);
            if (stringArray.length > 1) {
                Locator locator2;
                locator = locator2 = Locator.makeLocator(locator, stringArray[1]);
            }
            ToolBox.warn(locator.paramString());
        }
        catch (InvalidLocatorException invalidLocatorException) {
            ToolBox.warn("Can't make locator : " + stringArray[0], invalidLocatorException);
        }
        catch (IOException iOException) {
            ToolBox.warn("Can't connect : " + stringArray[0], iOException);
        }
    }

    private static final void printUsage() {
        System.out.println("Usage   : java org.demo.webwader.Locator [parent] child");
    }
}

