/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader;

import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.ariane.tools.ToolBox;
import org.ariane.tools.TryProg;
import org.demo.webwader.VersionInfo;

class LinkChecker
extends TryProg {
    private String link;

    public static void main(String[] stringArray) {
        LinkChecker linkChecker = new LinkChecker("LinkChecker");
        if (!linkChecker.parseArg(stringArray)) {
            ToolBox.warn("Can't parse command line");
            return;
        }
        if (!linkChecker.run()) {
            ToolBox.warn("Can't run " + linkChecker.getName());
            System.exit(0);
        }
    }

    public LinkChecker(String string) {
        super(string);
    }

    public boolean run() {
        try {
            String string;
            if (ToolBox.verbose) {
                ToolBox.warn("Connecting to " + this.link);
            }
            URL uRL = new URL(this.link);
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("HEAD");
            int n = 0;
            while ((string = ((URLConnection)httpURLConnection).getHeaderField(n)) != null) {
                String string2 = ((URLConnection)httpURLConnection).getHeaderFieldKey(n);
                if (string2 == null) {
                    System.out.println(n + " : " + string);
                } else {
                    System.out.println(n + " : " + string2 + " = " + string);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            ToolBox.warn("Can't check document", exception);
            return false;
        }
        return true;
    }

    private final void printUsage() {
        System.out.println("Usage   : java org.demo.webwader.LinkChecker [options] link");
        System.out.println("Options : [-v|-d|-q][-V][-h]");
    }

    private final void printCodes() {
        StringBuffer stringBuffer = new StringBuffer("HTTP return codes :\n ");
        stringBuffer.append("ACCEPTED          : ");
        stringBuffer.append(202).append("\n ");
        stringBuffer.append("BAD_GATEWAY       : ");
        stringBuffer.append(502).append("\n ");
        stringBuffer.append("BAD_METHOD        : ");
        stringBuffer.append(405).append("\n ");
        stringBuffer.append("BAD_REQUEST       : ");
        stringBuffer.append(400).append("\n ");
        stringBuffer.append("CLIENT_TIMEOUT    : ");
        stringBuffer.append(408).append("\n ");
        stringBuffer.append("CONFLICT          : ");
        stringBuffer.append(409).append("\n ");
        stringBuffer.append("CREATED           : ");
        stringBuffer.append(201).append("\n ");
        stringBuffer.append("ENTITY_TOO_LARGE  : ");
        stringBuffer.append(413).append("\n ");
        stringBuffer.append("FORBIDDEN         : ");
        stringBuffer.append(403).append("\n ");
        stringBuffer.append("GATEWAY_TIMEOUT   : ");
        stringBuffer.append(504).append("\n ");
        stringBuffer.append("GONE              : ");
        stringBuffer.append(410).append("\n ");
        stringBuffer.append("INTERNAL_ERROR    : ");
        stringBuffer.append(500).append("\n ");
        stringBuffer.append("LENGTH_REQUIRED   : ");
        stringBuffer.append(411).append("\n ");
        stringBuffer.append("MOVED_PERM        : ");
        stringBuffer.append(301).append("\n ");
        stringBuffer.append("MOVED_TEMP        : ");
        stringBuffer.append(302).append("\n ");
        stringBuffer.append("MULT_CHOICE       : ");
        stringBuffer.append(300).append("\n ");
        stringBuffer.append("NO_CONTENT        : ");
        stringBuffer.append(204).append("\n ");
        stringBuffer.append("NOT_ACCEPTABLE    : ");
        stringBuffer.append(406).append("\n ");
        stringBuffer.append("NOT_AUTHORITATIVE : ");
        stringBuffer.append(203).append("\n ");
        stringBuffer.append("NOT_FOUND         : ");
        stringBuffer.append(404).append("\n ");
        stringBuffer.append("NOT_MODIFIED      : ");
        stringBuffer.append(304).append("\n ");
        stringBuffer.append("OK                : ");
        stringBuffer.append(200).append("\n ");
        stringBuffer.append("PARTIAL           : ");
        stringBuffer.append(206).append("\n ");
        stringBuffer.append("PAYMENT_REQUIRED  : ");
        stringBuffer.append(402).append("\n ");
        stringBuffer.append("PRECON_FAILED     : ");
        stringBuffer.append(412).append("\n ");
        stringBuffer.append("PROXY_AUTH        : ");
        stringBuffer.append(407).append("\n ");
        stringBuffer.append("REQ_TOO_LONG      : ");
        stringBuffer.append(414).append("\n ");
        stringBuffer.append("RESET             : ");
        stringBuffer.append(205).append("\n ");
        stringBuffer.append("SEE_OTHER         : ");
        stringBuffer.append(303).append("\n ");
        stringBuffer.append("UNAUTHORIZED      : ");
        stringBuffer.append(401).append("\n ");
        stringBuffer.append("UNAVAILABLE       : ");
        stringBuffer.append(503).append("\n ");
        stringBuffer.append("UNSUPPORTED_TYPE  : ");
        stringBuffer.append(415).append("\n ");
        stringBuffer.append("USE_PROXY         : ");
        stringBuffer.append(305).append("\n ");
        stringBuffer.append("VERSION           : ");
        stringBuffer.append(505).append("\n ");
        System.out.println(stringBuffer.toString());
    }

    public boolean parseArg(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n++];
            int n3 = 1;
            while (n3 < string.length()) {
                char c = string.charAt(n3);
                switch (c) {
                    case 'V': {
                        VersionInfo.print();
                        break;
                    }
                    case 'q': {
                        ToolBox.verbose = false;
                        ToolBox.debug = false;
                        break;
                    }
                    case 'v': {
                        ToolBox.verbose = true;
                        ToolBox.debug = false;
                        break;
                    }
                    case 'd': {
                        ToolBox.verbose = true;
                        ToolBox.debug = true;
                        break;
                    }
                    default: {
                        this.printUsage();
                        this.printCodes();
                        ++n2;
                    }
                }
                ++n3;
            }
        }
        if (n < stringArray.length) {
            this.link = stringArray[n];
        }
        return n2 == 0;
    }
}

