/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader;

import java.io.IOException;
import org.ariane.tools.ToolBox;
import org.ariane.tools.TryProg;
import org.demo.webwader.Resources;
import org.demo.webwader.VersionInfo;
import org.demo.webwader.WebNode;
import org.demo.webwader.WebSite;

class CheckSite
extends TryProg {
    private String filename;

    public static void main(String[] stringArray) {
        ToolBox.debug = true;
        ToolBox.verbose = true;
        CheckSite checkSite = new CheckSite("CheckSite");
        if (!checkSite.parseArg(stringArray)) {
            ToolBox.warn("Can't parse command line");
            return;
        }
        if (!checkSite.run()) {
            ToolBox.warn("Can't run " + checkSite.getName());
            return;
        }
    }

    public CheckSite(String string) {
        super(string);
    }

    protected void setResources() {
        this.resources = Resources.instance();
    }

    public boolean run() {
        WebSite webSite = new WebSite();
        try {
            if (ToolBox.verbose) {
                ToolBox.warn("Reading from " + this.filename);
            }
            webSite.read(this.filename);
            WebNode webNode = webSite.getTopNode();
            System.out.println();
            System.out.print("BreadthFirst : ");
            webNode.dumpBreadthFirst();
            System.out.println();
            System.out.print("PreOrder : ");
            webNode.dumpPreorder();
            System.out.println();
            System.out.print("PostOrder : ");
            webNode.dumpPostorder();
            System.out.println();
            String string = ToolBox.markAsTemp(this.filename);
            webSite.write(string);
            if (ToolBox.verbose) {
                ToolBox.warn("Saved in " + string);
            }
            if (this.resources.get("WebWader.XML.Save", ToolBox.hasXML())) {
                string = webSite.getName() + ".xml~";
                webSite.writeXML(string);
                if (ToolBox.verbose) {
                    ToolBox.warn("Saved in " + string);
                }
            }
        }
        catch (IOException iOException) {
            ToolBox.warn("Can't read or write site", iOException);
            return false;
        }
        catch (Exception exception) {
            ToolBox.warn("Can't test site", exception);
            return false;
        }
        return true;
    }

    private final void printUsage() {
        System.out.println("Usage   : java org.demo.webwader.CheckSite [options] filename");
        System.out.println("Options : [-v|-d|-q][-V][-h]");
    }

    public boolean parseArg(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n++];
            int n3 = 1;
            while (n3 < string.length()) {
                char c = string.charAt(n3);
                switch (c) {
                    case 'V': {
                        VersionInfo.print();
                        break;
                    }
                    case 'q': {
                        ToolBox.verbose = false;
                        ToolBox.debug = false;
                        break;
                    }
                    case 'v': {
                        ToolBox.verbose = true;
                        ToolBox.debug = false;
                        break;
                    }
                    case 'd': {
                        ToolBox.verbose = true;
                        ToolBox.debug = true;
                        break;
                    }
                    default: {
                        this.printUsage();
                        ++n2;
                    }
                }
                ++n3;
            }
        }
        if (n < stringArray.length) {
            this.filename = stringArray[n];
        }
        return n2 == 0;
    }
}

