/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.tools;

import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.ariane.tools.FileOpException;

public final class ToolBox {
    public static boolean verbose = false;
    public static boolean debug = false;
    public static final char tempfileMarker = '~';
    public static final double VLN10 = 1.0 / Math.log(10.0);
    public static final double EPSILON = 1.0E-5;
    public static final double HUGEVALUE = 1.0E9;
    public static final int WRONG = 1;
    public static final int OK = 0;
    private static ToolBox toolbox = null;
    private static char[] spaces;

    public static ToolBox instance() {
        if (toolbox == null) {
            toolbox = new ToolBox();
        }
        return toolbox;
    }

    private ToolBox() {
    }

    public final void printDate() {
        Date date = new Date();
        System.out.println(date);
    }

    public static Locale setLocale(String string) {
        Locale locale;
        if (string == null) {
            return Locale.getDefault();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        String string2 = null;
        String string3 = null;
        try {
            string2 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            ToolBox.warn("Invalid locale " + string);
            return null;
        }
        if (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            locale = new Locale(string2, string3, string4);
        } else {
            locale = new Locale(string2, string3);
        }
        Locale.setDefault(locale);
        return locale;
    }

    public static DecimalFormat scientificFormat(String string) {
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        decimalFormatSymbols.setGroupingSeparator(' ');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        ((NumberFormat)decimalFormat).setGroupingUsed(true);
        decimalFormat.applyPattern(string);
        return decimalFormat;
    }

    public static final void warn(String string, Exception exception) {
        ToolBox.warn(string + " : " + exception);
    }

    public static final void warn(String string) {
        System.out.println(string + " !");
    }

    public static void dot() {
        System.out.print('.');
        System.out.flush();
    }

    public static String readInputString() {
        String string = "";
        int n = 100;
        byte[] byArray = new byte[n];
        try {
            int n2 = System.in.read(byArray, 0, n);
            if (n2 < 1) {
                ToolBox.warn("Can't read bytes");
            } else {
                string = new String(byArray, 0, n2 - 1);
            }
        }
        catch (Exception exception) {
            ToolBox.warn("Can't get input string", exception);
        }
        return string;
    }

    public static String centerString(String string, int n) {
        int n2 = string.length();
        if (n2 > n) {
            return string.substring(0, n);
        }
        int n3 = (n - n2) / 2;
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(spaces, 0, n3).append(string).append(spaces, 0, n - n2 - n3);
        return stringBuffer.toString();
    }

    public static String padString(String string, int n) {
        if (n < 1) {
            return new String(string);
        }
        int n2 = string.length();
        if (n2 > n) {
            return string.substring(0, n);
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(spaces, 0, n - n2);
        return stringBuffer.toString();
    }

    public static String format(float f, int n) {
        String string = String.valueOf(f);
        int n2 = string.indexOf(46);
        return string.substring(0, n2 + n + 1);
    }

    public static String format(long l, int n) {
        String string = String.valueOf(l);
        int n2 = string.length();
        if (n <= n2) {
            return string;
        }
        try {
            return "                                                           ".substring(0, n - n2).concat(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static boolean underNetscape() {
        try {
            return System.getProperty("browser", "Unknown").startsWith("Netscape");
        }
        catch (Exception exception) {
            ToolBox.warn("Can't find browser type", exception);
            return false;
        }
    }

    public static boolean hasXML() {
        try {
            Class.forName("org.xml.sax.helpers.ParserFactory");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String XMLHeader(String string) {
        StringBuffer stringBuffer = new StringBuffer("<?xml version='1.0' encoding='ISO8859_1'?>");
        stringBuffer.append("\n<!-- Created by ").append(System.getProperty("user.name"));
        stringBuffer.append(" on ").append(new Date()).append(" with the JVS.  -->");
        if (string != null) {
            stringBuffer.append("\n<!-- ").append(string).append(" -->");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static double upperRoundValue(double d) {
        double d2;
        boolean bl = false;
        if (d < 0.0) {
            bl = true;
            d = -d;
        }
        if (d < 1.0E-5) {
            return 0.0;
        }
        if ((d /= (d2 = ToolBox.powerOfTen(d))) <= 1.0) {
            d = 1.0;
        } else if (d <= 2.0) {
            d = 2.0;
        } else if (d <= 5.0) {
            d = 5.0;
        } else if (d <= 10.0) {
            d = 10.0;
        }
        if (bl) {
            d = -d;
        }
        return d * d2;
    }

    public static double powerOfTen(double d) {
        boolean bl = false;
        if (d < 0.0) {
            bl = true;
            d = -d;
        }
        d = d < 10.0 ? 1.0 : (d < 100.0 ? 10.0 : (d < 1000.0 ? 100.0 : (d < 1000.0 ? 100.0 : (d < 10000.0 ? 1000.0 : (d < 100000.0 ? 10000.0 : Math.pow(10.0, (int)(Math.log(d) * VLN10)))))));
        return bl ? -d : d;
    }

    public static final void renameFile(String string) throws FileOpException {
        File file = new File(ToolBox.markAsTemp(string));
        File file2 = new File(string);
        if (!file2.exists()) {
            if (!file.renameTo(file2)) {
                throw new FileOpException("Can't rename " + file + " to " + file2);
            }
            return;
        }
        File file3 = new File(string + '%');
        if (!file2.renameTo(file3)) {
            throw new FileOpException("Can't rename " + file2 + " to " + file3);
        }
        if (!file.renameTo(file2)) {
            throw new FileOpException("Can't rename " + file + " to " + file2);
        }
        if (!file3.renameTo(file)) {
            throw new FileOpException("Can't rename " + file3 + " to " + file);
        }
    }

    public static final String markAsTemp(String string) {
        return string + '~';
    }

    public static final boolean isUnderUnix() {
        return File.separatorChar == '/';
    }

    public static final boolean isUnderWindows() {
        return File.separatorChar == '\\';
    }

    public static final String getJVSOrigin() {
        String string = System.getProperty("java.class.path");
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        String string2 = "JVS" + File.separatorChar + "src";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.indexOf("jvs.jar") < 0 && string3.indexOf(string2) < 0) continue;
            return string3;
        }
        return null;
    }

    static {
        int n = 80;
        spaces = new char[n];
        int n2 = 0;
        while (n2 < n) {
            ToolBox.spaces[n2] = 32;
            ++n2;
        }
    }
}

