/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.tools;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.ariane.tools.InputDataset;
import org.ariane.tools.LinesReader;
import org.ariane.tools.ToolBox;

public class StreamReader
implements LinesReader {
    private BufferedReader reader;
    protected int line;
    private static final String com = "#";
    private long laps;
    private static final int limit = 1000000;

    public StreamReader(InputDataset inputDataset) {
        if (inputDataset == null || inputDataset.input == null) {
            throw new IllegalArgumentException("Invalid input !");
        }
        this.reader = new BufferedReader(new InputStreamReader(inputDataset.input));
        this.laps = 0L;
        this.reset();
        try {
            this.reader.mark(1000000);
        }
        catch (Exception exception) {
            ToolBox.warn("Can't mark dataset", exception);
        }
    }

    public synchronized void rewind() {
        try {
            this.reader.reset();
        }
        catch (Exception exception) {
            ToolBox.warn("Can't rewind dataset", exception);
        }
    }

    protected synchronized void reset() {
        this.line = 0;
    }

    public final synchronized void close() {
        try {
            this.reader.close();
            this.reset();
        }
        catch (Exception exception) {
            ToolBox.warn("Can't close dataset", exception);
        }
    }

    public final synchronized int lineNumber() {
        return this.line - 1;
    }

    public final void setIdleTime(long l) {
        this.laps = l;
    }

    public synchronized String nextLine() {
        String string = "";
        try {
            while ((string = this.reader.readLine()) != null) {
                String string2;
                if (this.laps > 0L) {
                    Thread.sleep(this.laps);
                }
                if ((string2 = string.trim()).length() < 1 || string2.startsWith(com)) continue;
                int n = string.indexOf(com);
                if (n > 0) {
                    string = string.substring(0, n);
                }
                ++this.line;
                return string;
            }
        }
        catch (Exception exception) {
            ToolBox.warn("Error NextLine " + string);
            ToolBox.warn("Can't read line " + this.lineNumber(), exception);
        }
        return null;
    }
}

